/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.math.LoggingTimerEMA;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.math.TimerEMA;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class Diagnostics {
    private static final TimerEMA clientTick = new TimerEMA("Client Tick");
    private static final TimerEMA lastTick = new TimerEMA("Last Tick");
    private static final LoggingTimerEMA diagnostics = new LoggingTimerEMA("Diagnostics");
    private static long lastTickMark = -1L;
    private static long timeMark = 0L;
    private static float tps = 0.0f;
    private static DiagnosticEvent lastEvent = new DiagnosticEvent();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void startTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            timeMark = System.nanoTime();
            if (lastTickMark != -1L) {
                lastTick.update(timeMark - lastTickMark);
                tps = MathStuff.clamp((float)(50.0 / lastTick.getMSecs() * 20.0), 0.0f, 20.0f);
            }
            lastTickMark = timeMark;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void endTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long delta = System.nanoTime() - timeMark;
            clientTick.update(delta);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (GameUtils.displayDebug()) {
            diagnostics.begin();
            DiagnosticEvent evt = new DiagnosticEvent();
            evt.getRight().add("");
            evt.getRight().add(TextFormatting.LIGHT_PURPLE + clientTick.toString());
            evt.getRight().add(TextFormatting.LIGHT_PURPLE + lastTick.toString());
            evt.getRight().add(TextFormatting.LIGHT_PURPLE + diagnostics.toString());
            evt.getRight().add(TextFormatting.LIGHT_PURPLE + String.format("TPS:%7.3fms", Float.valueOf(tps)));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            lastEvent = evt;
            if (!lastEvent.getTimers().isEmpty()) {
                for (TimerEMA timer : lastEvent.getTimers()) {
                    evt.getRight().add(TextFormatting.GREEN + timer.toString());
                }
            }
            if (!lastEvent.getRenderTimers().isEmpty()) {
                for (TimerEMA timer : lastEvent.getRenderTimers()) {
                    evt.getRight().add(TextFormatting.AQUA + timer.toString());
                }
            }
            diagnostics.end();
        }
    }

    @SubscribeEvent
    public static void onGatherText(@Nonnull RenderGameOverlayEvent.Text event) {
        if (GameUtils.displayDebug()) {
            if (!lastEvent.getLeft().isEmpty()) {
                event.getLeft().addAll(lastEvent.getLeft());
            }
            if (!lastEvent.getRight().isEmpty()) {
                event.getRight().addAll(lastEvent.getRight());
            }
        }
    }
}

