/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.fml;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.collections.ObjectArray;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientLoginChecks {
    private static final ObjectArray<ICallbackHandler> handlers = new ObjectArray();

    public static void register(@Nonnull ICallbackHandler handler) {
        handlers.add(handler);
    }

    @SubscribeEvent
    public static void onLogin(@Nonnull ClientPlayerNetworkEvent.LoggedInEvent event) {
        ClientPlayerEntity player = event.getPlayer();
        if (player != null) {
            Lib.LOGGER.info("Player login: %s", event.getPlayer().func_200200_C_().getString());
            for (ICallbackHandler callback : handlers) {
                ITextComponent msg = callback.onClientLogin(event.getPlayer());
                if (msg == null) continue;
                event.getPlayer().func_145747_a(msg, Util.field_240973_b_);
            }
        }
    }

    @FunctionalInterface
    public static interface ICallbackHandler {
        @Nullable
        public ITextComponent onClientLogin(@Nonnull ClientPlayerEntity var1);
    }
}

