/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.capability;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.heat.HeatCapability;
import lehjr.numina.util.capabilities.heat.HeatItemWrapper;
import lehjr.numina.util.capabilities.heat.IHeatStorage;
import lehjr.numina.util.capabilities.inventory.modularitem.ModularItem;
import lehjr.numina.util.capabilities.inventory.modularitem.NuminaRangedWrapper;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.render.IModelSpecNBT;
import lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import lehjr.powersuits.client.render.ArmorModelSpecNBT;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.constants.MPSRegistryNames;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PowerArmorCap
implements ICapabilityProvider {
    final ItemStack itemStack;
    final EquipmentSlotType targetSlot;
    final ModularItem modularItem;
    final LazyOptional<IItemHandler> modularItemHolder;
    final ArmorModelSpecNBT modelSpec;
    final LazyOptional<IModelSpecNBT> modelSpecHolder;
    final HeatItemWrapper heatStorage;
    final LazyOptional<IHeatStorage> heatHolder;
    final LazyOptional<IEnergyStorage> energyHolder;
    final LazyOptional<IFluidHandlerItem> fluidHolder;
    double maxHeat;

    public PowerArmorCap(@Nonnull ItemStack itemStackIn, EquipmentSlotType slot) {
        this.itemStack = itemStackIn;
        this.targetSlot = slot;
        final HashMap rangedWrapperMap = new HashMap();
        switch (this.targetSlot) {
            case HEAD: {
                this.modularItem = new ModularItem(this.itemStack, 18){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatHelmet();
                break;
            }
            case CHEST: {
                this.modularItem = new ModularItem(this.itemStack, 18){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatChestplate();
                break;
            }
            case LEGS: {
                this.modularItem = new ModularItem(itemStackIn, 10){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatLegs();
                break;
            }
            case FEET: {
                this.modularItem = new ModularItem(this.itemStack, 8){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(ModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatBoots();
                break;
            }
            default: {
                this.modularItem = new ModularItem(this.itemStack, 8);
            }
        }
        this.modularItemHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            return this.modularItem;
        });
        this.modelSpec = new ArmorModelSpecNBT(itemStackIn);
        this.modelSpecHolder = LazyOptional.of(() -> this.modelSpec);
        this.heatStorage = new HeatItemWrapper(this.itemStack, this.maxHeat, this.modularItem.getStackInSlot(0).getCapability(PowerModuleCapability.POWER_MODULE));
        this.heatHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            this.heatStorage.updateFromNBT();
            return this.heatStorage;
        });
        this.energyHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            return (IEnergyStorage)this.modularItem.getStackInSlot(1).getCapability(CapabilityEnergy.ENERGY).orElse((Object)new EnergyStorage(0));
        });
        this.fluidHolder = LazyOptional.of(() -> {
            if (this.targetSlot == EquipmentSlotType.CHEST) {
                this.modularItem.updateFromNBT();
                return (IFluidHandlerItem)this.modularItem.getOnlineModuleOrEmpty(MPSRegistryNames.FLUID_TANK_MODULE).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse((Object)new EmptyFluidHandler());
            }
            return new EmptyFluidHandler();
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        LazyOptional modularItemCapability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.modularItemHolder);
        if (modularItemCapability.isPresent()) {
            return modularItemCapability;
        }
        LazyOptional modelSpecCapability = ModelSpecNBTCapability.RENDER.orEmpty(cap, this.modelSpecHolder);
        if (modelSpecCapability.isPresent()) {
            return modelSpecCapability;
        }
        LazyOptional heatCapability = HeatCapability.HEAT.orEmpty(cap, this.heatHolder);
        if (heatCapability.isPresent()) {
            return heatCapability;
        }
        LazyOptional energyCapability = CapabilityEnergy.ENERGY.orEmpty(cap, this.energyHolder);
        if (energyCapability.isPresent()) {
            return energyCapability;
        }
        LazyOptional fluidCapability = CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.fluidHolder);
        if (fluidCapability.isPresent()) {
            return fluidCapability;
        }
        return LazyOptional.empty();
    }

    class EmptyFluidHandler
    extends FluidHandlerItemStack {
        public EmptyFluidHandler() {
            super(ItemStack.field_190927_a, 0);
        }
    }
}

