/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.modechanging;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lehjr.numina.network.NuminaPackets;
import lehjr.numina.network.packets.ModeChangeRequestPacket;
import lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.client.gui.clickable.ClickableModule;
import lehjr.numina.util.client.gui.frame.IGuiFrame;
import lehjr.numina.util.client.gui.gemoetry.IDrawable;
import lehjr.numina.util.client.gui.gemoetry.IRect;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.util.client.gui.gemoetry.RelativeRect;
import lehjr.numina.util.client.gui.gemoetry.SpiralPointToPoint2D;
import lehjr.numina.util.client.render.MuseRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class RadialModeSelectionFrame
extends RelativeRect
implements IGuiFrame {
    boolean visible = true;
    boolean enabled = true;
    protected final long spawnTime;
    protected List<ClickableModule> modeButtons = new ArrayList<ClickableModule>();
    protected int selectedModuleOriginal = -1;
    protected int selectedModuleNew = -1;
    protected PlayerEntity player;
    protected double radius;
    protected ItemStack stack;
    float zLevel;

    public RadialModeSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, PlayerEntity player, float zLevel) {
        super(topleft, bottomright);
        this.spawnTime = System.currentTimeMillis();
        this.player = player;
        this.radius = Math.min(this.finalWidth(), this.finalHeight());
        this.stack = player.field_71071_by.func_70448_g();
        this.zLevel = zLevel;
        this.loadItems();
    }

    public RelativeRect init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
        super.initGrowth();
        this.radius = Math.min(this.finalWidth(), this.finalHeight());
        this.modeButtons.clear();
        return this;
    }

    public boolean mouseClicked(double x, double y, int button) {
        return false;
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        return false;
    }

    public void update(double mousex, double mousey) {
        this.loadItems();
        if (System.currentTimeMillis() - this.spawnTime > 250L) {
            this.selectModule((float)mousex, (float)mousey);
        }
        if (this.getSelectedModule() != null && this.selectedModuleOriginal != this.selectedModuleNew) {
            this.selectedModuleOriginal = this.selectedModuleNew;
            this.stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(handler -> {
                handler.setActiveMode(this.getSelectedModule().getInventorySlot());
                NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new ModeChangeRequestPacket(this.getSelectedModule().getInventorySlot(), this.player.field_71071_by.field_70461_c));
            });
        }
    }

    public void func_230430_a_(MatrixStack matrixStackIn, int mouseX, int mouseY, float partialTicks) {
        for (ClickableModule mode : this.modeButtons) {
            mode.func_230430_a_(matrixStackIn, mouseX, mouseY, partialTicks);
        }
        this.drawSelection(matrixStackIn);
    }

    public float getZLevel() {
        return 0.0f;
    }

    public IDrawable setZLevel(float v) {
        return this;
    }

    private void loadItems() {
        if (this.player != null && this.modeButtons.isEmpty()) {
            this.stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(handler -> {
                List modes = handler.getValidModes();
                int activeMode = handler.getActiveMode();
                if (activeMode > 0) {
                    this.selectedModuleOriginal = activeMode;
                }
                int modeNum = 0;
                Iterator iterator = modes.iterator();
                while (iterator.hasNext()) {
                    int mode = (Integer)iterator.next();
                    ClickableModule clickie = new ClickableModule(handler.getStackInSlot(mode), (MusePoint2D)new SpiralPointToPoint2D(this.getPosition(), this.radius, 4.71238898038469 - Math.PI * 2 * (double)modeNum / (double)modes.size(), 250.0), mode, ModuleCategory.NONE);
                    this.modeButtons.add(clickie);
                    ++modeNum;
                }
            });
        }
    }

    private void selectModule(float x, float y) {
        if (this.modeButtons != null) {
            int i = 0;
            for (ClickableModule module : this.modeButtons) {
                if (module.hitBox((double)x, (double)y)) {
                    this.selectedModuleNew = i;
                    break;
                }
                ++i;
            }
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.modeButtons.size() > this.selectedModuleNew && this.selectedModuleNew != -1) {
            return this.modeButtons.get(this.selectedModuleNew);
        }
        return null;
    }

    public void drawSelection(MatrixStack matrixStackIn) {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            MusePoint2D pos = module.getPosition();
            MuseRenderer.drawCircleAround((MatrixStack)matrixStackIn, (double)pos.getX(), (double)pos.getY(), (double)10.0, (float)this.zLevel);
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            return module.getToolTip(x, y);
        }
        return null;
    }

    public RelativeRect getRect() {
        return this;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setOnInit(IRect.IInit iInit) {
    }

    public void onInit() {
    }
}

