/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.model.helper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lehjr.numina.util.capabilities.render.modelspec.EnumSpecType;
import lehjr.numina.util.capabilities.render.modelspec.ModelPartSpec;
import lehjr.numina.util.capabilities.render.modelspec.ModelRegistry;
import lehjr.numina.util.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.util.capabilities.render.modelspec.SpecBase;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.armor.AbstractElectricItemArmor;
import lehjr.powersuits.item.tool.PowerFist;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;

public class DefaultModelSpec {
    public static CompoundNBT makeModelPrefs(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof AbstractElectricItemArmor) {
                return DefaultModelSpec.makeModelPrefs(stack, ((AbstractElectricItemArmor)stack.func_77973_b()).func_185083_B_());
            }
            if (stack.func_77973_b() instanceof PowerFist) {
                return DefaultModelSpec.makeModelPrefs(stack, EquipmentSlotType.MAINHAND);
            }
        }
        return new CompoundNBT();
    }

    public static CompoundNBT makeModelPrefs(@Nonnull ItemStack stack, EquipmentSlotType slot) {
        if (stack.func_190926_b()) {
            return new CompoundNBT();
        }
        ArrayList<CompoundNBT> prefArray = new ArrayList<CompoundNBT>();
        ListNBT specList = new ListNBT();
        CompoundNBT texSpecTag = new CompoundNBT();
        List<Integer> colours = new ArrayList<Integer>();
        for (SpecBase spec : ModelRegistry.getInstance().getSpecs()) {
            if (!spec.isDefault()) continue;
            if (stack.func_77973_b() instanceof PowerFist && spec.getSpecType().equals((Object)EnumSpecType.HANDHELD)) {
                colours = DefaultModelSpec.addNewColourstoList(colours, spec.getColours());
                for (PartSpecBase partSpec : spec.getPartSpecs()) {
                    if (!(partSpec instanceof ModelPartSpec)) continue;
                    prefArray.add(((ModelPartSpec)partSpec).multiSet(new CompoundNBT(), Integer.valueOf(DefaultModelSpec.getNewColourIndex(colours, spec.getColours(), partSpec.getDefaultColourIndex())), Boolean.valueOf(((ModelPartSpec)partSpec).getGlow())));
                }
                continue;
            }
            if (!(stack.func_77973_b() instanceof AbstractElectricItemArmor)) continue;
            colours = DefaultModelSpec.addNewColourstoList(colours, spec.getColours());
            if (spec.getSpecType().equals((Object)EnumSpecType.ARMOR_SKIN) && spec.get((Object)slot.func_188450_d()) != null) {
                texSpecTag = ((PartSpecBase)spec.get((Object)slot.func_188450_d())).multiSet(new CompoundNBT(), Integer.valueOf(DefaultModelSpec.getNewColourIndex(colours, spec.getColours(), ((PartSpecBase)spec.get((Object)slot.func_188450_d())).getDefaultColourIndex())));
                continue;
            }
            if (!spec.getSpecType().equals((Object)EnumSpecType.ARMOR_MODEL) || !MPSSettings.allowHighPollyArmor()) continue;
            for (PartSpecBase partSpec : spec.getPartSpecs()) {
                if (partSpec.getBinding().getSlot() != slot) continue;
                prefArray.add(((ModelPartSpec)partSpec).multiSet(new CompoundNBT(), Integer.valueOf(DefaultModelSpec.getNewColourIndex(colours, spec.getColours(), partSpec.getDefaultColourIndex())), Boolean.valueOf(((ModelPartSpec)partSpec).getGlow())));
            }
        }
        CompoundNBT nbt = new CompoundNBT();
        for (CompoundNBT elem : prefArray) {
            nbt.func_218657_a(elem.func_74779_i("model") + "." + elem.func_74779_i("part"), (INBT)elem);
        }
        if (!specList.isEmpty()) {
            nbt.func_218657_a("specList", (INBT)specList);
        }
        if (!texSpecTag.isEmpty()) {
            nbt.func_218657_a("texSpec", (INBT)texSpecTag);
        }
        nbt.func_218657_a("colours", (INBT)new IntArrayNBT(colours));
        return nbt;
    }

    static List<Integer> addNewColourstoList(List<Integer> colours, List<Integer> coloursToAdd) {
        for (Integer i : coloursToAdd) {
            if (colours.contains(i)) continue;
            colours.add(i);
        }
        return colours;
    }

    public static int getNewColourIndex(List<Integer> colours, List<Integer> oldColours, Integer index) {
        return colours.indexOf(oldColours.get(index != null ? index : 0));
    }
}

