/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    protected ForgeConfigSpec.DoubleValue GENERAL_MAX_FLYING_SPEED;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_POWERFIST;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_HELMET;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_CHEST;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_LEGS;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_FEET;
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> GENERAL_VEIN_MINER_ORE_LIST;
    protected ForgeConfigSpec.ConfigValue<List<?>> GENERAL_VEIN_MINER_BLOCK_LIST;
    protected ForgeConfigSpec.BooleanValue COSMETIC_USE_LEGACY_COSMETIC_SYSTEM;
    protected ForgeConfigSpec.BooleanValue COSMETIC_ALLOW_HIGH_POLLY_ARMOR_MODELS;
    protected ForgeConfigSpec.BooleanValue COSMETIC_ALLOW_POWER_FIST_CUSTOMIZATOIN;

    protected ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General settings").push("General");
        this.GENERAL_MAX_FLYING_SPEED = builder.comment("Maximum flight speed (in m/s)").translation("config.powersuits.general.maxFlyingSpeed").defineInRange("maximumFlyingSpeedmps", 25.0, 0.0, 3.4028234663852886E38);
        this.GENERAL_BASE_MAX_HEAT_POWERFIST = builder.comment("PowerFistModel2 Base Heat Cap").translation("config.powersuits.general.maxHeatBasePowerFist").defineInRange("baseMaxHeatPowerFist", 5.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_HELMET = builder.comment("Power Armor Helmet Heat Cap").translation("config.powersuits.general.maxHeatBaseHelmet").defineInRange("baseMaxHeatHelmet", 5.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_CHEST = builder.comment("Power Armor Chestplate Heat Cap").translation("config.powersuits.general.maxHeatBaseChestplate").defineInRange("baseMaxHeatChest", 20.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_LEGS = builder.comment("Power Armor Leggings Heat Cap").translation("config.powersuits.general.maxHeatBaseLeggings").defineInRange("baseMaxHeatLegs", 15.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_FEET = builder.comment("Power Armor Boots Heat Cap").translation("config.powersuits.general.maxHeatBaseFeet").defineInRange("baseMaxHeatFeet", 5.0, 0.0, 5000.0);
        this.GENERAL_VEIN_MINER_ORE_LIST = builder.comment("Ore tag list for vein miner module.").translation("config.powersuits.general.maxVeinMinerOreList").worldRestart().defineList("veinMinerOres", Arrays.asList("forge:ores/iron", "forge:ores/copper", "forge:ores/tin", "forge:ores/lead", "forge:ores/aluminum", "forge:ores/aluminium", "forge:ores/silver", "forge:ores/gold", "forge:ores/cinnabar", "forge:ores/zinc", "forge:ores/uranium", "forge:ores/platinum", "forge:ores/bismuth", "forge:ores/osmium", "forge:ores/coal", "forge:ores/redstone", "minecraft:glowstone", "forge:ores/diamond", "forge:ores/lapis", "forge:ores/quartz", "forge:ores/fluorite"), o -> o instanceof String && !((String)o).isEmpty());
        this.GENERAL_VEIN_MINER_BLOCK_LIST = builder.comment("Block registry name whitelist for the vein miner module. \nUse for blocks that don't have an ore tag or to fine tune which blocks to break").translation("config.powersuits.general.maxVeinMinerBlockList").worldRestart().defineList("veinMinerBlocks", Collections.emptyList(), o -> o instanceof String && !((String)o).isEmpty());
        builder.pop();
        builder.comment("Model cosmetic settings").push("Cosmetic");
        this.COSMETIC_USE_LEGACY_COSMETIC_SYSTEM = builder.comment("Use legacy cosmetic configuration instead of cosmetic presets").translation("config.powersuits.cosmetic.useLegacyCosmeticSystem").worldRestart().define("useLegacyCosmeticSystem", true);
        this.COSMETIC_ALLOW_HIGH_POLLY_ARMOR_MODELS = builder.comment("Allow high polly armor models instead of just skins").translation("config.powersuits.cosmetic.allowHighPollyArmorModuels").define("allowHighPollyArmorModuels", true);
        this.COSMETIC_ALLOW_POWER_FIST_CUSTOMIZATOIN = builder.comment("Allow PowerFistModel2 model to be customized").translation("config.powersuits.cosmetic.allowPowerFistCustomization").define("allowPowerFistCustomization", true);
        builder.pop();
        builder.push("Modules");
        builder.push("Armor");
        builder.push("plating_leather");
        builder.defineInRange("base_armorPhysical", 3.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_maxHeat", 75.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_knockbackResistance", 0.25, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("energy_shield");
        builder.defineInRange("armorEnergy_fieldStrength_multiplier", 6.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("armorEnergyPerDamage_fieldStrength_multiplier", 5000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("maxHeat_fieldStrength_multiplier", 500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_knockbackResistance", 0.25, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("plating_iron");
        builder.defineInRange("base_armorPhysical", 4.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_maxHeat", 300.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_knockbackResistance", 0.25, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("plating_diamond");
        builder.defineInRange("base_armorPhysical", 5.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_maxHeat", 400.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_knockbackResistance", 0.25, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("Cosmetic");
        builder.push("transparent_armor");
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("Energy Generation");
        builder.push("generator_solar");
        builder.defineInRange("base_daytimeEnergyGen", 15000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_nightTimeEnergyGen", 1500.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("generator_solar_adv");
        builder.defineInRange("base_daytimeEnergyGen", 45000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_nightTimeEnergyGen", 1500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_daytimeHeatGen", 15.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_nightTimeHeatGen", 5.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("generator_kinetic");
        builder.defineInRange("base_energyPerBlock", 2000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyPerBlock_energyGenerated_multiplier", 6000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_movementResistance", (double)0.01f, 0.0, Double.MAX_VALUE);
        builder.defineInRange("movementResistance_energyGenerated_multiplier", (double)0.49f, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("generator_thermal");
        builder.defineInRange("base_energyPerBlock", 250.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyPerBlock_energyGenerated_multiplier", 250.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("Environment");
        builder.push("auto_feeder");
        builder.defineInRange("base_energyConsumption", 100.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_autoFeederEfficiency", 50.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_efficiency_multiplier", 1000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("autoFeederEfficiency_efficiency_multiplier", 50.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("cooling_system");
        builder.defineInRange("coolingBonus_power_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyConsumption_power_multiplier", 40.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("fluid_tank");
        builder.defineInRange("base_fluidTankSize", 20000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_heatActivationPercent", 0.5, 0.0, Double.MAX_VALUE);
        builder.defineInRange("heatActivationPercent_activationPercent_multiplier", 0.5, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("mob_repulsor");
        builder.defineInRange("base_energyConsumption", 2500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("water_electrolyzer");
        builder.defineInRange("base_energyConsumption", 10000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.pop();
        builder.pop();
        builder.push("Mining Enhancement");
        builder.push("aoe_pick_upgrade");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyConsumption_diameter_multiplier", 9500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("aoeMiningDiameter_diameter_multiplier", 5, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("aqua_affinity");
        builder.defineInRange("base_energyConsumption", 0.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_harvSpeed", (double)0.2f, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_power_multiplier", 1000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("harvSpeed_power_multiplier", (double)0.8f, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("fortune");
        builder.defineInRange("base_fortuneEnCon", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("fortuneEnCon_enchLevel_multiplier", 9500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("fortuneLevel_enchLevel_multiplier", 3, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("silk_touch");
        builder.defineInRange("base_silkTouchEnCon", 2500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("vein_miner");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.pop();
        builder.pop();
        builder.push("Movement");
        builder.push("blink_drive");
        builder.defineInRange("base_energyConsumption", 10000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_blinkDriveRange", 5.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_range_multiplier", 30000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("blinkDriveRange_range_multiplier", 59.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("climb_assist");
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("dim_rift_gen");
        builder.defineInRange("base_heatGen", 55.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_energyConsumption", 200000.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("flight_control");
        builder.defineInRange("yLookRatio_vertically_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("glider");
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("jet_boots");
        builder.defineInRange("base_energyConsumption", 0.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_jetbootsThrust", 0.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_thrust_multiplier", 750.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("jetbootsThrust_thrust_multiplier", (double)0.08f, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("jetpack");
        builder.defineInRange("base_energyConsumption", 0.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_jetpackThrust", 0.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_thrust_multiplier", 1500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("jetpackThrust_thrust_multiplier", (double)0.16f, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("jump_assist");
        builder.defineInRange("base_energyConsumption", 0.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyConsumption_power_multiplier", 250.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("multiplier_power_multiplier", 4.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_compensation_multiplier", 50.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_sprintExComp", 0.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("sprintExComp_compensation_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("parachute");
        builder.defineInRange("energyConsumption_thrust_multiplier", 1000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("underwaterMovBoost_thrust_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("shock_absorber");
        builder.defineInRange("base_energyConsumption", 0.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyConsumption_power_multiplier", 100.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_multiplier", 0.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("multiplier_power_multiplier", 10.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("sprint_assist");
        builder.defineInRange("base_sprintEnergyCon", 0.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("sprintEnergyCon_sprintAssist_multiplier", 100.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_sprintSpeedMult", (double)0.01f, 0.0, Double.MAX_VALUE);
        builder.defineInRange("sprintSpeedMult_sprintAssist_multiplier", (double)2.49f, 0.0, Double.MAX_VALUE);
        builder.defineInRange("sprintEnergyCon_compensation_multiplier", 20.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_sprintExComp", 0.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("sprintExComp_compensation_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_walkingEnergyCon", 0.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("walkingEnergyCon_walkingAssist_multiplier", 100.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_walkingSpeedMult", (double)0.01f, 0.0, Double.MAX_VALUE);
        builder.defineInRange("walkingSpeedMult_walkingAssist_multiplier", (double)1.99f, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("swim_assist");
        builder.defineInRange("energyConsumption_thrust_multiplier", 1000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("underwaterMovBoost_thrust_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("Special");
        builder.push("invisibility");
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("magnet");
        builder.defineInRange("base_energyConsumption", 0.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyConsumption_power_multiplier", 2000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_radius", 5.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("radius_power_multiplier", 10.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("Tool");
        builder.push("axe");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_harvSpeed", 8.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_overclock_multiplier", 9500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("harvSpeed_overclock_multiplier", 22.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("diamond_pick_upgrade");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("flint_and_steel");
        builder.defineInRange("base_energyConsumption", 10000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.pop();
        builder.push("hoe");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyConsumption_radius_multiplier", 9500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("radius_radius_multiplier", 8.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("leaf_blower");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("energyConsumption_radius_multiplier", 9500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_radius", 1.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("radius_radius_multiplier", 15.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("luxcapacitor_module");
        builder.defineInRange("base_energyConsumption", 1000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("redHue_red_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("greenHue_green_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("blueHue_blue_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("opacity_alpha_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("pickaxe");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_harvSpeed", 8.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_overclock_multiplier", 9500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("harvSpeed_overclock_multiplier", 52.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("shears");
        builder.defineInRange("base_energyConsumption", 1000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_harvSpeed", 8.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("shovel");
        builder.defineInRange("base_energyConsumption", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_harvSpeed", 8.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("energyConsumption_overclock_multiplier", 9500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("harvSpeed_overclock_multiplier", 22.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("Vision");
        builder.push("binoculars");
        builder.defineInRange("base_fieldOfView", 0.5, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("fieldOfView_fOVMult_multiplier", 9.5, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("night_vision");
        builder.define("isAllowed", true);
        builder.pop();
        builder.pop();
        builder.push("Weapon");
        builder.push("blade_launcher");
        builder.defineInRange("base_spinBladeEnergyCon", 5000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_spinBladeDam", 6.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("lightning_summoner");
        builder.defineInRange("base_energyConsumption", 4900000.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_heatEmission", 100.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("melee_assist");
        builder.defineInRange("base_punchEnergyCon", 10.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_meleeDamage", 2.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("punchEnergyCon_impact_multiplier", 1000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("meleeDamage_impact_multiplier", 8.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("punchEnergyCon_carryThrough_multiplier", 200.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("meleeKnockback_carryThrough_multiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("plasma_cannon");
        builder.defineInRange("base_plasmaEnergyPerTick", 100.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_plasmaDamage", 2.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("plasmaEnergyPerTick_amperage_multiplier", 1500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("plasmaDamage_amperage_multiplier", 38.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("plasmaEnergyPerTick_voltage_multiplier", 500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("plasmaExplosiveness_voltage_multiplier", 0.5, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("railgun");
        builder.defineInRange("base_railgunTotalImpulse", 500.0, 0.0, Double.MAX_VALUE);
        builder.define("isAllowed", true);
        builder.defineInRange("base_railgunEnergyCost", 5000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("base_railgunHeatEm", 2.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("railgunTotalImpulse_voltage_multiplier", 2500.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("railgunEnergyCost_voltage_multiplier", 25000.0, 0.0, Double.MAX_VALUE);
        builder.defineInRange("railgunHeatEm_voltage_multiplier", 10.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.pop();
    }
}

