/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import lehjr.numina.basemod.NuminaObjects;
import lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.client.gui.slot.HideableSlotItemHandler;
import lehjr.numina.util.client.gui.slot.IHideableSlot;
import lehjr.numina.util.client.gui.slot.IIConProvider;
import lehjr.numina.util.client.render.MuseIconUtils;
import lehjr.numina.util.math.Colour;
import lehjr.numina.util.math.MuseMathUtils;
import lehjr.powersuits.basemod.MPSObjects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InstallSalvageContainer
extends Container {
    EquipmentSlotType slotType;
    int mainInventoryStart = 0;
    int hotbarInventoryStart = 0;

    public InstallSalvageContainer(int containerID, PlayerInventory playerInventory, EquipmentSlotType slotType) {
        super((ContainerType)MPSObjects.INSTALL_SALVAGE_CONTAINER_TYPE.get(), containerID);
        int col;
        this.slotType = slotType;
        int parentSlot = slotType == EquipmentSlotType.MAINHAND ? playerInventory.field_70461_c : this.equipmentSlotToParent(slotType);
        playerInventory.field_70458_d.func_184582_a(slotType).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iItemHandler -> {
            for (int modularItemInvIndex = 0; modularItemInvIndex < iItemHandler.getSlots(); ++modularItemInvIndex) {
                if (MuseMathUtils.isIntInRange((org.apache.commons.lang3.tuple.Pair)iItemHandler.getRangeForCategory(ModuleCategory.ARMOR), (int)modularItemInvIndex)) {
                    this.func_75146_a((Slot)new IconSlot((IItemHandler)iItemHandler, parentSlot, modularItemInvIndex, -1000, -1000){

                        @OnlyIn(value=Dist.CLIENT)
                        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                            return NuminaObjects.getSlotBackground((EquipmentSlotType)EquipmentSlotType.OFFHAND);
                        }

                        @OnlyIn(value=Dist.CLIENT)
                        public void drawIconAt(MatrixStack matrixStack, double v, double v1, Colour colour) {
                        }
                    });
                    continue;
                }
                if (MuseMathUtils.isIntInRange((org.apache.commons.lang3.tuple.Pair)iItemHandler.getRangeForCategory(ModuleCategory.ENERGY_STORAGE), (int)modularItemInvIndex)) {
                    this.func_75146_a((Slot)new IconSlot((IItemHandler)iItemHandler, parentSlot, modularItemInvIndex, -1000, -1000){

                        @OnlyIn(value=Dist.CLIENT)
                        public void drawIconAt(MatrixStack matrixStack, double posX, double posY, Colour colour) {
                            MuseIconUtils.getIcon().energyStorageBackground.renderIconScaledWithColour(matrixStack, posX, posY, 16.0, 16.0, Colour.WHITE);
                        }
                    });
                    continue;
                }
                if (MuseMathUtils.isIntInRange((org.apache.commons.lang3.tuple.Pair)iItemHandler.getRangeForCategory(ModuleCategory.ENERGY_GENERATION), (int)modularItemInvIndex)) {
                    this.func_75146_a((Slot)new IconSlot((IItemHandler)iItemHandler, parentSlot, modularItemInvIndex, -1000, -1000){

                        @OnlyIn(value=Dist.CLIENT)
                        public void drawIconAt(MatrixStack matrixStack, double posX, double posY, Colour colour) {
                            MuseIconUtils.getIcon().energyGenerationBackground.renderIconScaledWithColour(matrixStack, posX, posY, 16.0, 16.0, Colour.WHITE);
                        }
                    });
                    continue;
                }
                this.func_75146_a((Slot)new HideableSlotItemHandler((IItemHandler)iItemHandler, parentSlot, modularItemInvIndex, -1000, -1000));
            }
        });
        this.mainInventoryStart = this.field_75151_b.size();
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        this.hotbarInventoryStart = this.field_75151_b.size();
        for (col = 0; col < 9; ++col) {
            if (col == playerInventory.field_70461_c) {
                if (playerInventory.func_70301_a(playerInventory.field_70461_c).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).isPresent()) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, col, 8 + col * 18, 142){

                        public boolean func_82869_a(PlayerEntity player) {
                            return false;
                        }
                    });
                    continue;
                }
            }
            this.func_75146_a(new Slot((IInventory)playerInventory, col, 8 + col * 18, 142));
        }
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof IHideableSlot)) continue;
            ((IHideableSlot)slot).disable();
        }
    }

    public EquipmentSlotType getEquipmentSlotType() {
        return this.slotType;
    }

    int equipmentSlotToParent(EquipmentSlotType slotType) {
        switch (slotType) {
            case HEAD: {
                return 39;
            }
            case CHEST: {
                return 38;
            }
            case LEGS: {
                return 37;
            }
            case FEET: {
                return 36;
            }
            case OFFHAND: {
                return 40;
            }
        }
        return -1;
    }

    public int getMainInventoryStart() {
        return this.mainInventoryStart;
    }

    public int getHotbarInventoryStart() {
        return this.hotbarInventoryStart;
    }

    public void func_75134_a(PlayerEntity playerEntity) {
        super.func_75134_a(playerEntity);
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.mainInventoryStart ? !this.func_75135_a(itemstack1, this.mainInventoryStart, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.mainInventoryStart, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    abstract class IconSlot
    extends HideableSlotItemHandler
    implements IIConProvider {
        public IconSlot(IItemHandler itemHandler, int parent, int index, int xPosition, int yPosition) {
            super(itemHandler, parent, index, xPosition, yPosition);
        }

        public IconSlot(IItemHandler itemHandler, int parent, int index, int xPosition, int yPosition, boolean isEnabled) {
            super(itemHandler, parent, index, xPosition, yPosition, isEnabled);
        }
    }
}

