/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.entity;

import lehjr.numina.util.math.Colour;
import lehjr.powersuits.basemod.MPSObjects;
import lehjr.powersuits.block.LuxCapacitorBlock;
import lehjr.powersuits.tile_entity.LuxCapacitorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class LuxCapacitorEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    public Colour color;

    public LuxCapacitorEntity(EntityType<? extends LuxCapacitorEntity> entityType, World world) {
        super(entityType, world);
        this.func_189654_d(true);
        if (this.color == null) {
            this.color = LuxCapacitorBlock.defaultColor;
        }
    }

    public LuxCapacitorEntity(World world, LivingEntity shootingEntity, Colour color) {
        super((EntityType)MPSObjects.LUX_CAPACITOR_ENTITY_TYPE.get(), shootingEntity, world);
        this.func_189654_d(true);
        this.color = color != null ? color : LuxCapacitorBlock.defaultColor;
        Vector3d direction = shootingEntity.func_70040_Z().func_72432_b();
        double speed = 1.0;
        this.func_213293_j(direction.field_72450_a * speed, direction.field_72448_b * speed, direction.field_72449_c * speed);
        double r = 0.4375;
        this.func_70107_b(shootingEntity.func_226277_ct_(), shootingEntity.func_226278_cu_() + (double)shootingEntity.func_70047_e(), shootingEntity.func_226281_cx_());
        this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - r, this.func_226278_cu_() - 0.0625, this.func_226281_cx_() - r, this.func_226277_ct_() + r, this.func_226278_cu_() + 0.0625, this.func_226281_cx_() + r));
    }

    BlockItemUseContext getUseContext(BlockPos pos, Direction facing, BlockRayTraceResult hitResult) {
        return new BlockItemUseContext(new ItemUseContext((PlayerEntity)this.func_234616_v_(), ((PlayerEntity)this.func_234616_v_()).func_184600_cs(), hitResult));
    }

    protected void func_70227_a(RayTraceResult hitResult) {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        if (this.color == null) {
            this.color = Colour.WHITE;
        }
        if (this.func_70089_S() && hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockState blockState;
            BlockRayTraceResult blockRayTrace = (BlockRayTraceResult)hitResult;
            Direction dir = blockRayTrace.func_216354_b().func_176734_d();
            int x = blockRayTrace.func_216350_a().func_177958_n() - dir.func_82601_c();
            int y = blockRayTrace.func_216350_a().func_177956_o() - dir.func_96559_d();
            int z = blockRayTrace.func_216350_a().func_177952_p() - dir.func_82599_e();
            BlockPos blockPos = new BlockPos(x, y, z);
            BlockItemUseContext context = this.getUseContext(blockPos, blockRayTrace.func_216354_b(), blockRayTrace);
            if (y > 0 && this.field_70170_p.func_180495_p(blockPos).func_196953_a(context) && !this.placedBlock(blockState = ((LuxCapacitorBlock)MPSObjects.LUX_CAPACITOR_BLOCK.get()).func_196258_a(this.getUseContext(blockPos, blockRayTrace.func_216354_b(), blockRayTrace)), blockPos)) {
                Direction facing;
                Direction[] directionArray = context.func_196009_e();
                int n = directionArray.length;
                for (int i = 0; i < n && !this.placedBlock(blockState = (BlockState)blockState.func_206870_a((Property)LuxCapacitorBlock.field_176387_N, (Comparable)(facing = directionArray[i])), blockPos); ++i) {
                }
            }
            this.func_70106_y();
        }
    }

    boolean placedBlock(BlockState state, BlockPos pos) {
        if (state.func_196955_c((IWorldReader)this.field_70170_p, pos)) {
            this.field_70170_p.func_175656_a(pos, state);
            this.field_70170_p.func_175690_a(pos, (TileEntity)new LuxCapacitorTileEntity(this.color));
            return true;
        }
        return false;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 400) {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.color.getInt());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.color = new Colour(additionalData.readInt());
    }
}

