/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.entity;

import lehjr.powersuits.basemod.MPSObjects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class PlasmaBallEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Float> CHARGE_PERCENT = EntityDataManager.func_187226_a(PlasmaBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> EXPLOSIVENESS = EntityDataManager.func_187226_a(PlasmaBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DAMAGINESS = EntityDataManager.func_187226_a(PlasmaBallEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public PlasmaBallEntity(EntityType<? extends PlasmaBallEntity> entityType, World world) {
        super(entityType, world);
    }

    public PlasmaBallEntity(World world, LivingEntity shootingEntity, float finalExplosiveness, float finalDamaginess, float chargePercent) {
        super((EntityType)MPSObjects.PLASMA_BALL_ENTITY_TYPE.get(), world);
        this.func_212361_a((Entity)shootingEntity);
        this.field_70180_af.func_187227_b(CHARGE_PERCENT, (Object)Float.valueOf(chargePercent));
        this.field_70180_af.func_187227_b(EXPLOSIVENESS, (Object)Float.valueOf(finalExplosiveness));
        this.field_70180_af.func_187227_b(DAMAGINESS, (Object)Float.valueOf(finalDamaginess));
        Vector3d direction = shootingEntity.func_70040_Z().func_72432_b();
        double radius = chargePercent;
        this.func_70107_b(shootingEntity.func_226277_ct_(), shootingEntity.func_226278_cu_() + (double)shootingEntity.func_70047_e(), shootingEntity.func_226281_cx_());
        this.func_213317_d(direction);
        this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - radius, this.func_226278_cu_() - radius, this.func_226281_cx_() - radius, this.func_226277_ct_() + radius, this.func_226278_cu_() + radius, this.func_226281_cx_() + radius));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CHARGE_PERCENT, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(EXPLOSIVENESS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DAMAGINESS, (Object)Float.valueOf(0.0f));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa > this.getMaxLifetime()) {
            this.func_70106_y();
        }
        if (this.func_70090_H()) {
            this.func_70106_y();
            int i = 0;
            while ((float)i < this.getChargePercent() * 50.0f) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + Math.random() * 1.0, this.func_226278_cu_() + Math.random() * 1.0, this.func_226281_cx_() + Math.random() * 0.1, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    public int getMaxLifetime() {
        return 200;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void func_70227_a(RayTraceResult result) {
        switch (result.func_216346_c()) {
            case ENTITY: {
                EntityRayTraceResult rayTraceResult = (EntityRayTraceResult)result;
                if (rayTraceResult.func_216348_a() == null || rayTraceResult.func_216348_a() == this.func_234616_v_()) break;
                rayTraceResult.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), ((Float)this.field_70180_af.func_187225_a(DAMAGINESS)).floatValue());
                break;
            }
            case BLOCK: {
                break;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f * ((Float)this.field_70180_af.func_187225_a(EXPLOSIVENESS)).floatValue(), flag ? Explosion.Mode.DESTROY : Explosion.Mode.BREAK);
        }
        for (int var3 = 0; var3 < 8; ++var3) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + Math.random() * 0.1, this.func_226278_cu_() + Math.random() * 0.1, this.func_226281_cx_() + Math.random() * 0.1, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public float getChargePercent() {
        return ((Float)this.field_70180_af.func_187225_a(CHARGE_PERCENT)).floatValue();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(((Float)this.field_70180_af.func_187225_a(CHARGE_PERCENT)).floatValue());
        buffer.writeFloat(((Float)this.field_70180_af.func_187225_a(EXPLOSIVENESS)).floatValue());
        buffer.writeFloat(((Float)this.field_70180_af.func_187225_a(DAMAGINESS)).floatValue());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.field_70180_af.func_187227_b(CHARGE_PERCENT, (Object)Float.valueOf(additionalData.readFloat()));
        this.field_70180_af.func_187227_b(EXPLOSIVENESS, (Object)Float.valueOf(additionalData.readFloat()));
        this.field_70180_af.func_187227_b(DAMAGINESS, (Object)Float.valueOf(additionalData.readFloat()));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

