/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.entity;

import javax.annotation.Nullable;
import lehjr.powersuits.basemod.MPSObjects;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class RailgunBoltEntity
extends DamagingProjectileEntity
implements IEntityAdditionalSpawnData {
    private double damage = 2.0;
    private int knockbackStrength;
    private double velocity;
    private double chargePercent;
    int piercedEntities = 0;
    private final SoundEvent hitSound = SoundEvents.field_187539_bB;

    public RailgunBoltEntity(EntityType<? extends RailgunBoltEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public RailgunBoltEntity(World world, LivingEntity shooter, double velocity, double chargePercent, double damage, double knockback) {
        super((EntityType)MPSObjects.RAILGUN_BOLT_ENTITY_TYPE.get(), world);
        this.velocity = velocity;
        this.damage = damage;
        this.knockbackStrength = (int)knockback;
        this.func_212361_a((Entity)shooter);
        this.func_70029_a(world);
        if (shooter instanceof PlayerEntity) {
            Vector3d direction = shooter.func_70040_Z().func_72432_b();
            if (chargePercent >= 0.75) {
                this.func_70015_d((int)(chargePercent * 10.0));
            }
            this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_());
            this.func_213317_d(direction.func_186678_a(velocity));
        }
        this.func_189654_d(true);
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        Vector3d hitVec = result.func_216347_e();
        this.drawParticleStreamTo(hitVec);
    }

    protected void func_213868_a(EntityRayTraceResult traceResult) {
        DamageSource damagesource;
        Entity entity1;
        super.func_213868_a(traceResult);
        Entity entity = traceResult.func_216348_a();
        int pierceLimit = (int)(5.0 * this.chargePercent);
        if (pierceLimit > 0) {
            if (this.piercedEntities >= pierceLimit + 1) {
                this.func_70106_y();
                return;
            }
            ++this.piercedEntities;
        }
        if ((entity1 = this.func_234616_v_()) == null) {
            damagesource = RailgunBoltEntity.causeBoltDamage(this, (Entity)this);
        } else {
            damagesource = RailgunBoltEntity.causeBoltDamage(this, entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        int fireTimer = entity.func_223314_ad();
        if (this.func_70027_ad()) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, (float)this.damage)) {
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockbackStrength > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                if (entity1 != null && livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
            }
            this.func_184185_a(this.hitSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (pierceLimit <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_241209_g_(fireTimer);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                this.func_70106_y();
            }
        }
    }

    public static DamageSource causeBoltDamage(RailgunBoltEntity arrow, @Nullable Entity indirectEntityIn) {
        return new IndirectEntityDamageSource("bolt", (Entity)arrow, indirectEntityIn).func_76349_b();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            Vector3d vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            this.func_213317_d(vector3d.func_186678_a((double)this.getWaterDrag()));
        }
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa > this.getMaxLifetime()) {
            this.func_70106_y();
        }
        Vector3d motion = this.func_213322_ci();
        if (motion.field_72450_a == 0.0 && motion.field_72448_b == 0.0 && motion.field_72449_c == 0.0) {
            this.func_70106_y();
        }
    }

    protected void func_230299_a_(BlockRayTraceResult rayTraceResult) {
        super.func_230299_a_(rayTraceResult);
        this.func_184185_a(this.hitSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    protected void func_70088_a() {
    }

    public int getMaxLifetime() {
        return 200;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void drawParticleStreamTo(Vector3d hitVec) {
        Entity source = this.func_234616_v_();
        if (source != null && source instanceof PlayerEntity) {
            double x = hitVec.field_72450_a;
            double y = hitVec.field_72448_b;
            double z = hitVec.field_72449_c;
            PlayerEntity shooter = (PlayerEntity)source;
            Vector3d direction = shooter.func_70040_Z().func_72432_b();
            double xoffset = 1.3f;
            double yoffset = -0.2;
            double zoffset = 0.3f;
            Vector3d horzdir = direction.func_72432_b();
            horzdir = new Vector3d(horzdir.field_72450_a, 0.0, horzdir.field_72449_c);
            horzdir = horzdir.func_72432_b();
            double cx = shooter.func_226277_ct_() + direction.field_72450_a * xoffset - direction.field_72448_b * horzdir.field_72450_a * yoffset - horzdir.field_72449_c * zoffset;
            double cy = shooter.func_226278_cu_() + (double)shooter.func_70047_e() + direction.field_72448_b * xoffset + (1.0 - Math.abs(direction.field_72448_b)) * yoffset;
            double cz = shooter.func_226281_cx_() + direction.field_72449_c * xoffset - direction.field_72448_b * horzdir.field_72449_c * yoffset + horzdir.field_72450_a * zoffset;
            double dx = x - cx;
            double dy = y - cy;
            double dz = z - cz;
            double ratio = Math.sqrt(dx * dx + dy * dy + dz * dz);
            while (Math.abs(cx - x) > Math.abs(dx / ratio)) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, cx, cy, cz, 0.0, 0.0, 0.0);
                cx += dx * 0.1 / ratio;
                cy += dy * 0.1 / ratio;
                cz += dz * 0.1 / ratio;
            }
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeDouble(this.damage);
        buffer.writeInt(this.knockbackStrength);
        buffer.writeDouble(this.velocity);
        buffer.writeDouble(this.chargePercent);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.damage = additionalData.readDouble();
        this.knockbackStrength = additionalData.readInt();
        this.velocity = additionalData.readDouble();
        this.chargePercent = additionalData.readDouble();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

