/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import lehjr.numina.config.NuminaSettings;
import lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.client.control.PlayerMovementInputWrapper;
import lehjr.numina.util.client.sound.Musique;
import lehjr.numina.util.client.sound.SoundDictionary;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.numina.util.math.MuseMathUtils;
import lehjr.numina.util.player.PlayerUtils;
import lehjr.powersuits.client.sound.MPSSoundDictionary;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.constants.MPSRegistryNames;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public enum MovementManager {
    INSTANCE;

    static final double root2;
    public static final Map<UUID, Double> playerJumpMultipliers;
    public static final double DEFAULT_GRAVITY = -0.0784000015258789;

    public double getPlayerJumpMultiplier(PlayerEntity player) {
        if (playerJumpMultipliers.containsKey(player.func_110124_au())) {
            return playerJumpMultipliers.get(player.func_110124_au());
        }
        return 0.0;
    }

    public void setPlayerJumpTicks(PlayerEntity player, double number) {
        playerJumpMultipliers.put(player.func_110124_au(), number);
    }

    public double computeFallHeightFromVelocity(double velocity) {
        double ticks = velocity / -0.0784000015258789;
        return 0.03920000076293945 * ticks * ticks;
    }

    public static void removeModifiers(@Nonnull ItemStack itemStack) {
        itemStack.func_196083_e("AttributeModifiers");
    }

    static double boolToVal(boolean boolIn) {
        return boolIn ? 1.0 : 0.0;
    }

    public static double thrust(PlayerEntity player, double thrust, boolean flightControl) {
        Vector3d desiredDirection;
        PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
        double thrustUsed = 0.0;
        if (flightControl) {
            desiredDirection = player.func_70040_Z().func_72432_b();
            double strafeX = desiredDirection.field_72449_c;
            double strafeZ = -desiredDirection.field_72450_a;
            double flightVerticality = player.func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iModularItem -> iModularItem.getOnlineModuleOrEmpty(MPSRegistryNames.FLIGHT_CONTROL_MODULE).getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.applyPropertyModifiers("yLookRatio")).orElse(0.0)).orElse(0.0);
            desiredDirection = new Vector3d(desiredDirection.field_72450_a * MovementManager.boolToVal(playerInput.forwardKey) + strafeX * (double)playerInput.strafeKey, flightVerticality * desiredDirection.field_72448_b * MovementManager.boolToVal(playerInput.forwardKey) + MovementManager.boolToVal(playerInput.jumpKey) - MovementManager.boolToVal(playerInput.downKey), desiredDirection.field_72449_c * MovementManager.boolToVal(playerInput.forwardKey) + strafeZ * (double)playerInput.strafeKey);
            desiredDirection = desiredDirection.func_72432_b();
            if (player.func_213322_ci().field_72448_b < 0.0 && desiredDirection.field_72448_b >= 0.0) {
                if (-player.func_213322_ci().field_72448_b > thrust) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, thrust, 0.0));
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= player.func_213322_ci().field_72448_b;
                    thrustUsed += player.func_213322_ci().field_72448_b;
                    player.func_213293_j(player.func_213322_ci().field_72450_a, 0.0, player.func_213322_ci().field_72449_c);
                }
            }
            if (player.func_213322_ci().field_72448_b < -1.0) {
                thrust += 1.0 + player.func_213322_ci().field_72448_b;
                thrustUsed -= 1.0 + player.func_213322_ci().field_72448_b;
                player.func_213293_j(player.func_213322_ci().field_72450_a, -1.0, player.func_213322_ci().field_72449_c);
            }
            if (Math.abs(player.func_213322_ci().field_72450_a) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.func_213322_ci().field_72450_a) > thrust) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(-(Math.signum(player.func_213322_ci().field_72450_a) * thrust), 0.0, 0.0));
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= Math.abs(player.func_213322_ci().field_72450_a);
                    thrustUsed += Math.abs(player.func_213322_ci().field_72450_a);
                    player.func_213293_j(0.0, player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c);
                }
            }
            if (Math.abs(player.func_213322_ci().field_72449_c) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.func_213322_ci().field_72449_c) > thrust) {
                    player.func_213317_d(player.func_213322_ci().func_178786_a(0.0, 0.0, Math.signum(player.func_213322_ci().field_72449_c) * thrust));
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrustUsed += Math.abs(player.func_213322_ci().field_72449_c);
                    thrust -= Math.abs(player.func_213322_ci().field_72449_c);
                    player.func_213293_j(player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b, 0.0);
                }
            }
            player.func_213317_d(player.func_213322_ci().func_72441_c(thrust * desiredDirection.field_72450_a, thrust * desiredDirection.field_72448_b, thrust * desiredDirection.field_72449_c));
            thrustUsed += thrust;
        } else {
            desiredDirection = player.func_70040_Z().func_72432_b();
            desiredDirection = new Vector3d(desiredDirection.field_72450_a, 0.0, desiredDirection.field_72449_c);
            desiredDirection.func_72432_b();
            if (!playerInput.forwardKey) {
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, thrust, 0.0));
            } else {
                player.func_213317_d(player.func_213322_ci().func_72441_c(desiredDirection.field_72450_a * thrust * root2 * MovementManager.boolToVal(playerInput.forwardKey), thrust * root2, desiredDirection.field_72449_c * thrust * root2));
            }
            thrustUsed += thrust;
        }
        double horzm2 = player.func_213322_ci().field_72450_a * player.func_213322_ci().field_72450_a + player.func_213322_ci().field_72449_c * player.func_213322_ci().field_72449_c;
        double horizontalLimit = MPSSettings.getMaxFlyingSpeed() * MPSSettings.getMaxFlyingSpeed() / 400.0;
        if (player.func_213453_ef() && horizontalLimit > 0.05) {
            horizontalLimit = 0.05;
        }
        if (horzm2 > horizontalLimit) {
            double ratio = Math.sqrt(horizontalLimit / horzm2);
            player.func_213293_j(player.func_213322_ci().field_72450_a * ratio, player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c * ratio);
        }
        PlayerUtils.resetFloatKickTicks((PlayerEntity)player);
        return thrustUsed;
    }

    public static double computePlayerVelocity(PlayerEntity player) {
        return MuseMathUtils.pythag((double)player.func_213322_ci().field_72450_a, (double)player.func_213322_ci().field_72448_b, (double)player.func_213322_ci().field_72449_c);
    }

    @SubscribeEvent
    public void handleLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.func_184582_a(EquipmentSlotType.LEGS).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> iModularItem.getOnlineModuleOrEmpty(MPSRegistryNames.JUMP_ASSIST_MODULE).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(jumper -> {
                double jumpAssist = jumper.applyPropertyModifiers("multiplier") * 2.0;
                double drain = jumper.applyPropertyModifiers("jumpEnergy");
                int avail = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                if (player.field_70170_p.func_201670_d() && NuminaSettings.useSounds()) {
                    Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JUMP_ASSIST, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(jumpAssist / 8.0)), (Float)Float.valueOf(1.0f), (Boolean)false);
                }
                if (drain < (double)avail) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)drain), (boolean)false);
                    this.setPlayerJumpTicks(player, jumpAssist);
                    double jumpCompensationRatio = jumper.applyPropertyModifiers("sprintExComp");
                    if (player.func_70051_ag()) {
                        player.func_71024_bL().func_75113_a((float)((double)-0.2f * jumpCompensationRatio));
                    } else {
                        player.func_71024_bL().func_75113_a((float)((double)-0.05f * jumpCompensationRatio));
                    }
                }
            }));
        }
    }

    @SubscribeEvent
    public void handleFallEvent(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && (double)event.getDistance() > 3.0) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.func_184582_a(EquipmentSlotType.FEET).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> iModularItem.getOnlineModuleOrEmpty(MPSRegistryNames.SHOCK_ABSORBER_MODULE).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(sa -> {
                int avail;
                double drain;
                double distanceAbsorb = (double)event.getDistance() * sa.applyPropertyModifiers("multiplier");
                if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.playerSound((PlayerEntity)player, (SoundEvent)SoundDictionary.SOUND_EVENT_GUI_INSTALL, (SoundCategory)SoundCategory.PLAYERS, (float)((float)distanceAbsorb), (Float)Float.valueOf(1.0f), (Boolean)false);
                }
                if ((drain = distanceAbsorb * sa.applyPropertyModifiers("shockEnergy")) < (double)(avail = ElectricItemUtils.getPlayerEnergy((LivingEntity)player))) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)drain), (boolean)false);
                    event.setDistance((float)((double)event.getDistance() - distanceAbsorb));
                }
            }));
        }
    }

    static {
        root2 = 1.0 / Math.sqrt(2.0);
        playerJumpMultipliers = new HashMap<UUID, Double>();
    }
}

