/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.energy_generation;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class KineticGeneratorModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.ENERGY_GENERATION, ModuleTarget.LEGSONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("energyPerBlock", 2000.0);
                    this.addTradeoffProperty("energyGenerated", "energyPerBlock", 6000.0, "FE");
                    this.addBaseProperty("movementResistance", 0.01f);
                    this.addTradeoffProperty("energyGenerated", "movementResistance", 0.49f, "%");
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack itemStackIn) {
                if (player.field_71075_bZ.field_75100_b || player.func_184218_aH() || player.func_184613_cA() || !player.func_233570_aj_()) {
                    this.onPlayerTickInactive(player, itemStackIn);
                }
                if (ElectricItemUtils.getPlayerEnergy((LivingEntity)player) < ElectricItemUtils.getMaxPlayerEnergy((LivingEntity)player) && !player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L && player.func_233570_aj_()) {
                    double distance = player.field_70140_Q - player.field_70141_P;
                    ElectricItemUtils.givePlayerEnergy((LivingEntity)player, (int)((int)(distance * 20.0 * this.applyPropertyModifiers("energyPerBlock"))));
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack itemStackIn) {
                this.getModuleStack().func_196083_e("AttributeModifiers");
            }
        }
    }
}

