/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.miningenhancement;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import lehjr.numina.util.capabilities.module.miningenhancement.MiningEnhancement;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.render.chameleon.Chameleon;
import lehjr.numina.util.capabilities.render.chameleon.ChameleonCapability;
import lehjr.numina.util.capabilities.render.chameleon.IChameleon;
import lehjr.numina.util.capabilities.render.highlight.HighLightCapability;
import lehjr.numina.util.capabilities.render.highlight.Highlight;
import lehjr.numina.util.capabilities.render.highlight.IHighlight;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.client.control.KeybindKeyHandler;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class AoEpickUpgradeModule2
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Enhancement miningEnhancement;
        private final LazyOptional<IPowerModule> powerModuleHolder;
        private final Chameleon chameleon;
        private final LazyOptional<IChameleon> chameleonHolder;
        private final Highlighter highlight;
        private final LazyOptional<IHighlight> highlightHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new Enhancement(module, ModuleCategory.MINING_ENHANCEMENT, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("aoe2Energy", 500.0, "FE");
                    this.addBaseProperty("aoe2Limit", 1.0);
                    this.addIntTradeoffProperty("aoe2Limit", "aoe2Limit", 59, "Blocks", 1, 0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.miningEnhancement.updateFromNBT();
                return this.miningEnhancement;
            });
            this.chameleon = new Chameleon(module);
            this.chameleonHolder = LazyOptional.of(() -> this.chameleon);
            this.highlight = new Highlighter();
            this.highlightHolder = LazyOptional.of(() -> this.highlight);
        }

        NonNullList<BlockPos> getPosList(Block block, BlockPos startPos, World world) {
            NonNullList list = NonNullList.func_191196_a();
            if (world.func_180495_p(startPos).func_177230_c() == block) {
                list.add((Object)startPos.func_185334_h());
                for (int i = 1; (double)list.size() <= this.miningEnhancement.applyPropertyModifiers("aoe2Limit") && i < 2; ++i) {
                    for (BlockPos.Mutable mutable : BlockPos.func_243514_a((BlockPos)startPos, (int)i, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
                        for (BlockPos.Mutable mutable2 : BlockPos.func_243514_a((BlockPos)mutable, (int)i, (Direction)Direction.UP, (Direction)Direction.NORTH)) {
                            for (BlockPos.Mutable mutable3 : BlockPos.func_243514_a((BlockPos)mutable2, (int)i, (Direction)Direction.WEST, (Direction)Direction.DOWN)) {
                                if (world.func_180495_p((BlockPos)mutable3).func_177230_c() != block || list.contains((Object)mutable3)) continue;
                                list.add((Object)new BlockPos((Vector3i)mutable3).func_185334_h());
                            }
                        }
                    }
                }
            }
            return list;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            LazyOptional chameleonCapability = ChameleonCapability.CHAMELEON.orEmpty(capability, this.chameleonHolder);
            if (chameleonCapability.isPresent()) {
                return chameleonCapability;
            }
            LazyOptional highlightCapability = HighLightCapability.HIGHLIGHT.orEmpty(capability, this.highlightHolder);
            if (highlightCapability.isPresent()) {
                return highlightCapability;
            }
            return LazyOptional.empty();
        }

        class Highlighter
        extends Highlight {
            Highlighter() {
            }

            @OnlyIn(value=Dist.CLIENT)
            NonNullList<BlockPos> findBlockPositionsClient(BlockPos targetPos) {
                return CapProvider.this.chameleon.getTargetBlock().map(targetBlock -> CapProvider.this.getPosList((Block)targetBlock, targetPos, Minecraft.func_71410_x().field_71439_g.field_70170_p)).orElse(NonNullList.func_191196_a());
            }

            public NonNullList<BlockPos> getBlockPositions(BlockRayTraceResult rayTraceResult) {
                return this.findBlockPositionsClient(rayTraceResult.func_216350_a());
            }
        }

        class Enhancement
        extends MiningEnhancement {
            public Enhancement(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult<ItemStack> use(@Nonnull ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                BlockRayTraceResult rayTraceResult;
                if (hand.equals((Object)Hand.MAIN_HAND) && worldIn.func_201670_d() && (KeybindKeyHandler.isKeyPressed(340) || KeybindKeyHandler.isKeyPressed(344)) && (rayTraceResult = AoEpickUpgradeModule2.func_219968_a((World)playerIn.field_70170_p, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE)) != null) {
                    CapProvider.this.chameleon.setTargetBlock(worldIn.func_180495_p(rayTraceResult.func_216350_a()).func_177230_c());
                }
                return super.use(itemStackIn, worldIn, playerIn, hand);
            }

            void harvestBlocks(List<BlockPos> posList, World world) {
                for (BlockPos pos : posList) {
                    Block.func_196263_a((BlockState)world.func_180495_p(pos), (BlockState)Blocks.field_150350_a.func_176223_P(), (IWorld)world, (BlockPos)pos, (int)3);
                }
            }

            public boolean onBlockStartBreak(ItemStack itemStack, BlockPos posIn, PlayerEntity player) {
                BlockState state = player.field_70170_p.func_180495_p(posIn);
                Block block = state.func_177230_c();
                if (block == Blocks.field_150350_a || block == Blocks.field_150357_h || !CapProvider.this.chameleon.getTargetBlock().filter(targetBlock -> targetBlock == block).isPresent()) {
                    return false;
                }
                int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                int energyUsage = this.getEnergyUsage();
                AtomicInteger bbModuleEnergyUsage = new AtomicInteger(0);
                itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(modeChanging -> {
                    for (ItemStack blockBreakingModule : modeChanging.getInstalledModulesOfType(IBlockBreakingModule.class)) {
                        if (!blockBreakingModule.getCapability(PowerModuleCapability.POWER_MODULE).filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).map(b -> {
                            if (b.canHarvestBlock(itemStack, state, player, posIn, playerEnergy - energyUsage)) {
                                bbModuleEnergyUsage.addAndGet(b.getEnergyUsage());
                                return true;
                            }
                            return false;
                        }).orElse(false).booleanValue()) continue;
                        break;
                    }
                });
                int energyRequired = this.getEnergyUsage() + bbModuleEnergyUsage.get();
                if (playerEnergy < energyRequired) {
                    return false;
                }
                NonNullList posList = CapProvider.this.getPosList(block, posIn, player.field_70170_p);
                NonNullList posListCopy = NonNullList.func_191196_a();
                for (BlockPos pos : posList) {
                    posListCopy.add((Object)pos);
                }
                int size = 0;
                int newSize = posListCopy.size();
                if (newSize == 1) {
                    return false;
                }
                if (newSize * energyRequired > playerEnergy) {
                    posList = NonNullList.func_191196_a();
                    posList.add((Object)posIn);
                    posListCopy.remove((Object)posIn);
                    for (BlockPos pos : posListCopy) {
                        if ((posList.size() + 1) * energyRequired <= playerEnergy) {
                            posList.add((Object)pos);
                            continue;
                        }
                        break;
                    }
                } else {
                    for (int i = 0; i < 100 && size != newSize && (double)posList.size() <= this.applyPropertyModifiers("aoe2Limit"); ++i) {
                        size = posListCopy.size();
                        block3: for (BlockPos pos : posListCopy) {
                            NonNullList<BlockPos> posList2 = CapProvider.this.getPosList(block, pos, player.field_70170_p);
                            for (BlockPos pos2 : posList2) {
                                if (posList.contains((Object)pos2)) continue;
                                if ((posList.size() + 1) * energyRequired > playerEnergy) {
                                    i = 1000;
                                    break block3;
                                }
                                posList.add((Object)pos2);
                            }
                        }
                        newSize = posList.size();
                        posListCopy = NonNullList.func_191196_a();
                        for (BlockPos pos : posList) {
                            posListCopy.add((Object)pos);
                        }
                    }
                }
                if (!player.field_70170_p.func_201670_d()) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)(energyRequired * posList.size()));
                }
                this.harvestBlocks((List<BlockPos>)posList, player.field_70170_p);
                return false;
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("aoe2Energy");
            }
        }
    }
}

