/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.movement;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.numina.util.player.PlayerUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class BlinkDriveModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final RightClickie rightClickie;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, ModuleCategory.MOVEMENT, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("blinkDriveEnergy", 10000.0, "FE");
                    this.addBaseProperty("blinkDriveRange", 5.0, "m");
                    this.addTradeoffProperty("range", "blinkDriveEnergy", 30000.0);
                    this.addTradeoffProperty("range", "blinkDriveRange", 59.0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.rightClickie);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult use(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                int range = (int)this.applyPropertyModifiers("blinkDriveRange");
                int energyConsumption = this.getEnergyUsage();
                RayTraceResult hitRayTrace = AbstractPowerModule.rayTrace(worldIn, playerIn, RayTraceContext.FluidMode.SOURCE_ONLY, range);
                if (hitRayTrace != null && hitRayTrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    double distance = hitRayTrace.func_216347_e().func_72438_d(playerIn.func_213303_ch());
                    energyConsumption = (int)((double)energyConsumption * (distance / (double)range));
                    if (ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn) > energyConsumption) {
                        PlayerUtils.resetFloatKickTicks((PlayerEntity)playerIn);
                        int amountDrained = ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, (int)energyConsumption);
                        worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                        PlayerUtils.teleportEntity((PlayerEntity)playerIn, (RayTraceResult)hitRayTrace);
                        worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                        return ActionResult.func_226248_a_((Object)itemStackIn);
                    }
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("blinkDriveEnergy");
            }
        }
    }
}

