/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.tool;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FlintAndSteelModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final RightClickie rightClickie;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, ModuleCategory.TOOL, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("flintAndSteelEnergy", 10000.0, "FE");
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.rightClickie);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResultType useOn(ItemUseContext context) {
                BlockPos blockpos;
                int energyConsumption = this.getEnergyUsage();
                PlayerEntity player = context.func_195999_j();
                if (ElectricItemUtils.getPlayerEnergy((LivingEntity)player) < energyConsumption) {
                    return ActionResultType.FAIL;
                }
                World world = context.func_195991_k();
                BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
                if (CampfireBlock.func_241470_h_((BlockState)blockstate)) {
                    world.func_184133_a(player, blockpos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    world.func_180501_a(blockpos, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
                    if (player != null) {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)energyConsumption);
                    }
                    return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
                }
                BlockPos blockpos1 = blockpos.func_177972_a(context.func_196000_l());
                if (AbstractFireBlock.func_241465_a_((World)world, (BlockPos)blockpos1, (Direction)context.func_195992_f())) {
                    world.func_184133_a(player, blockpos1, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    BlockState blockstate1 = AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)blockpos1);
                    world.func_180501_a(blockpos1, blockstate1, 11);
                    ItemStack itemstack = context.func_195996_i();
                    if (player instanceof ServerPlayerEntity) {
                        CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockpos1, itemstack);
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)energyConsumption);
                    }
                    return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
                }
                return ActionResultType.FAIL;
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("flintAndSteelEnergy");
            }
        }
    }
}

