/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.tool;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.numina.util.helper.ToolHelpers;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class LeafBlowerModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final RightClickie rightClickie;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, ModuleCategory.TOOL, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("leafBlowerCapEnergy", 500.0, "FE");
                    this.addTradeoffProperty("radius", "leafBlowerCapEnergy", 9500.0);
                    this.addBaseProperty("radius", 1.0, "m");
                    this.addTradeoffProperty("radius", "radius", 15.0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.rightClickie);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult use(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                int radius = (int)this.applyPropertyModifiers("radius");
                if (this.useBlower(radius, itemStackIn, playerIn, worldIn, playerIn.func_233580_cy_())) {
                    return ActionResult.func_226248_a_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            private boolean useBlower(int radius, ItemStack itemStack, PlayerEntity player, World world, BlockPos pos) {
                int totalEnergyDrain = 0;
                for (int i = pos.func_177958_n() - radius; i < pos.func_177958_n() + radius; ++i) {
                    for (int j = pos.func_177956_o() - radius; j < pos.func_177956_o() + radius; ++j) {
                        for (int k = pos.func_177952_p() - radius; k < pos.func_177952_p() + radius; ++k) {
                            BlockPos newPos = new BlockPos(i, j, k);
                            if (!ToolHelpers.blockCheckAndHarvest((PlayerEntity)player, (World)world, (BlockPos)newPos)) continue;
                            totalEnergyDrain += this.getEnergyUsage();
                        }
                    }
                }
                ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)totalEnergyDrain);
                return true;
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("leafBlowerCapEnergy");
            }
        }
    }
}

