/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.tool;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModule;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PickaxeModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final BlockBreaker blockBreaking;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.blockBreaking = new BlockBreaker(module, ModuleCategory.TOOL, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("pickaxeEnergy", 500.0, "FE");
                    this.addBaseProperty("pickaxeHarvestSpeed", 8.0, "x");
                    this.addTradeoffProperty("overclock", "pickaxeEnergy", 9500.0);
                    this.addTradeoffProperty("overclock", "pickaxeHarvestSpeed", 52.0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.blockBreaking);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class BlockBreaker
        extends PowerModule
        implements IBlockBreakingModule {
            public BlockBreaker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving, int playerEnergy) {
                if (this.canHarvestBlock(itemStack, state, (PlayerEntity)entityLiving, pos, playerEnergy)) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)entityLiving, (int)this.getEnergyUsage());
                    return true;
                }
                return false;
            }

            public ItemStack getEmulatedTool() {
                return new ItemStack((IItemProvider)Items.field_151035_b);
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("pickaxeEnergy");
            }

            public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
                event.setNewSpeed((float)((double)event.getNewSpeed() * this.applyPropertyModifiers("pickaxeHarvestSpeed")));
            }
        }
    }
}

