/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.weapon;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.numina.util.heat.MuseHeatUtils;
import lehjr.numina.util.math.MuseMathUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.entity.PlasmaBallEntity;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class PlasmaCannonModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final RightClickie rightClickie;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, ModuleCategory.WEAPON, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("plasmaEnergyPerTick", 100.0, "FE");
                    this.addBaseProperty("plasmaDamage", 2.0, "pt");
                    this.addTradeoffProperty("amperage", "plasmaEnergyPerTick", 1500.0, "FE");
                    this.addTradeoffProperty("amperage", "plasmaDamage", 38.0, "pt");
                    this.addTradeoffProperty("voltage", "plasmaEnergyPerTick", 500.0, "FE");
                    this.addTradeoffProperty("voltage", "plasmaExplosiveness", 0.5, "creeper");
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.rightClickie);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult use(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                if (hand == Hand.MAIN_HAND && ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn) > this.getEnergyUsage()) {
                    playerIn.func_184598_c(hand);
                    return ActionResult.func_226248_a_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            public void releaseUsing(ItemStack itemStack, World worldIn, LivingEntity entityLiving, int timeLeft) {
                int chargeTicks = (int)MuseMathUtils.clampDouble((double)(this.getUseDuration() - timeLeft), (double)10.0, (double)50.0);
                if (!worldIn.field_72995_K && entityLiving instanceof PlayerEntity) {
                    float damagingness;
                    float explosiveness;
                    PlasmaBallEntity plasmaBolt;
                    double chargePercent = (double)chargeTicks * 0.02;
                    double energyConsumption = (double)this.getEnergyUsage() * chargePercent;
                    PlayerEntity player = (PlayerEntity)entityLiving;
                    if ((double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > energyConsumption && worldIn.func_217376_c((Entity)(plasmaBolt = new PlasmaBallEntity(worldIn, (LivingEntity)player, explosiveness = (float)(this.applyPropertyModifiers("plasmaExplosiveness") * chargePercent), damagingness = (float)(this.applyPropertyModifiers("plasmaDamage") * chargePercent), (float)chargePercent)))) {
                        MuseHeatUtils.heatPlayer((LivingEntity)player, (double)(energyConsumption / 5000.0 * chargePercent));
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)energyConsumption));
                    }
                }
            }

            public int getEnergyUsage() {
                return (int)Math.round(this.applyPropertyModifiers("plasmaEnergyPerTick"));
            }
        }
    }
}

