/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.tool;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import lehjr.numina.util.capabilities.module.miningenhancement.IMiningEnhancementModule;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.basemod.MPSObjects;
import lehjr.powersuits.constants.MPSRegistryNames;
import lehjr.powersuits.item.tool.AbstractElectricTool;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.CapabilityItemHandler;

public class PowerFist
extends AbstractElectricTool {
    public PowerFist() {
        super(new Item.Properties().func_200916_a((ItemGroup)MPSObjects.creativeTab).func_200917_a(1).func_200915_b(0));
    }

    public int func_77626_a(ItemStack stack) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(handler -> handler.getActiveModule().getCapability(PowerModuleCapability.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(m -> m.getUseDuration()).orElse(72000)).orElse(72000);
    }

    public boolean func_179218_a(ItemStack powerFist, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)entityLiving);
        return powerFist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iItemHandler -> iItemHandler.getInstalledModulesOfType(IBlockBreakingModule.class).stream().anyMatch(module -> module.getCapability(PowerModuleCapability.POWER_MODULE).filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).map(pm -> pm.onBlockDestroyed(powerFist, worldIn, state, pos, entityLiving, playerEnergy)).orElse(false))).orElse(false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public Set<ToolType> getToolTypes(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iItemHandler -> {
            HashSet<ToolType> retSet = new HashSet<ToolType>();
            if (!iItemHandler.getOnlineModuleOrEmpty(MPSRegistryNames.PICKAXE_MODULE).func_190926_b()) {
                retSet.add(ToolType.PICKAXE);
            }
            if (!iItemHandler.getOnlineModuleOrEmpty(MPSRegistryNames.AXE_MODULE).func_190926_b()) {
                retSet.add(ToolType.AXE);
            }
            if (!iItemHandler.getOnlineModuleOrEmpty(MPSRegistryNames.SHOVEL_MODULE).func_190926_b()) {
                retSet.add(ToolType.SHOVEL);
            }
            if (!iItemHandler.getOnlineModuleOrEmpty(MPSRegistryNames.HOE_MODULE).func_190926_b()) {
                retSet.add(ToolType.HOE);
            }
            return retSet;
        }).orElse(new HashSet());
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity) {
            itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(iItemHandler -> iItemHandler.getOnlineModuleOrEmpty(MPSRegistryNames.MELEE_ASSIST_MODULE).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(pm -> {
                PlayerEntity player = (PlayerEntity)attacker;
                double drain = pm.applyPropertyModifiers("punchEnergyCon");
                if ((double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > drain) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)drain));
                    double damage = pm.applyPropertyModifiers("meleeDamage");
                    double knockback = pm.applyPropertyModifiers("meleeKnockback");
                    DamageSource damageSource = DamageSource.func_76365_a((PlayerEntity)player);
                    if (target.func_70097_a(damageSource, (float)((int)damage))) {
                        Vector3d lookVec = player.func_70040_Z();
                        target.func_70024_g(lookVec.field_72450_a * knockback, Math.abs(lookVec.field_72448_b + (double)0.2f) * knockback, lookVec.field_72449_c * knockback);
                    }
                }
            }));
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        super.onBlockStartBreak(itemstack, pos, player);
        return itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iItemHandler -> iItemHandler.getActiveModule().getCapability(PowerModuleCapability.POWER_MODULE).filter(IMiningEnhancementModule.class::isInstance).map(IMiningEnhancementModule.class::cast).filter(pm -> pm.isModuleOnline()).map(pm -> pm.onBlockStartBreak(itemstack, pos, player)).orElse(false)).orElse(false);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77969_a(newStack);
    }

    public int getHarvestLevel(ItemStack itemStack, ToolType toolType, @Nullable PlayerEntity player, @Nullable BlockState state) {
        return itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iItemHandler -> iItemHandler.getInstalledModulesOfType(IBlockBreakingModule.class).stream().mapToInt(module -> module.getCapability(PowerModuleCapability.POWER_MODULE).filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).map(pm -> pm.getEmulatedTool().getHarvestLevel(toolType, player, state)).orElse(-1)).max().orElse(-1)).orElse(-1);
    }

    public boolean canHarvestBlock(ItemStack itemStack, BlockState state) {
        return itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iItemHandler -> iItemHandler.getInstalledModulesOfType(IBlockBreakingModule.class).stream().anyMatch(module -> module.getCapability(PowerModuleCapability.POWER_MODULE).filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).map(pm -> pm.getEmulatedTool().func_150998_b(state)).orElse(false))).orElse(false);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType fallback = ActionResultType.PASS;
        Hand hand = context.func_221531_n();
        if (hand != Hand.MAIN_HAND) {
            return fallback;
        }
        return context.func_195996_i().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(handler -> {
            ItemStack module = handler.getActiveModule();
            return module.getCapability(PowerModuleCapability.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(m -> m.useOn(context)).orElse(fallback);
        }).orElse(fallback);
    }

    public ActionResultType onItemUseFirst(ItemStack itemStack, ItemUseContext context) {
        ActionResultType fallback = ActionResultType.PASS;
        Hand hand = context.func_221531_n();
        if (hand != Hand.MAIN_HAND) {
            return fallback;
        }
        return context.func_195996_i().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(handler -> {
            ItemStack module = handler.getActiveModule();
            return module.getCapability(PowerModuleCapability.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(m -> m.onItemUseFirst(itemStack, context)).orElse(fallback);
        }).orElse(fallback);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(handler -> {
            ItemStack module = handler.getActiveModule();
            module.getCapability(PowerModuleCapability.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).ifPresent(m -> m.releaseUsing(stack, worldIn, entityLiving, timeLeft));
        });
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entity) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(handler -> handler.getActiveModule().getCapability(PowerModuleCapability.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(m -> m.finishUsingItem(stack, worldIn, entity)).orElse(super.func_77654_b(stack, worldIn, entity))).orElse(stack);
    }

    public ActionResultType func_111207_a(ItemStack itemStackIn, PlayerEntity player, LivingEntity entity, Hand hand) {
        return itemStackIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(handler -> handler.getActiveModule().getCapability(PowerModuleCapability.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(m -> m.interactLivingEntity(itemStackIn, player, entity, hand).func_188397_a()).orElse(ActionResultType.PASS)).orElse(super.func_111207_a(itemStackIn, player, entity, hand));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerIn, Hand handIn) {
        ItemStack fist = playerIn.func_184586_b(handIn);
        ActionResult fallback = new ActionResult(ActionResultType.PASS, (Object)fist);
        if (handIn != Hand.MAIN_HAND) {
            return fallback;
        }
        return fist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(handler -> handler.getActiveModule().getCapability(PowerModuleCapability.POWER_MODULE).filter(IRightClickModule.class::isInstance).map(IRightClickModule.class::cast).map(rc -> rc.use(fist, world, playerIn, handIn)).orElse(fallback)).orElse(fallback);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }
}

