/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity;

import cofh.thermal.core.client.renderer.entity.model.BlizzModel;
import cofh.thermal.core.client.renderer.entity.model.ElementalProjectileModel;
import cofh.thermal.core.entity.monster.BlizzEntity;
import cofh.thermal.core.entity.projectile.BlizzProjectileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlizzRenderer
extends MobRenderer<BlizzEntity, BlizzModel<BlizzEntity>> {
    private static final ResourceLocation CALM_TEXTURE = new ResourceLocation("thermal", "textures/entity/blizz.png");
    private static final ResourceLocation ANGRY_TEXTURE = new ResourceLocation("thermal", "textures/entity/blizz_angry.png");
    private final ElementalProjectileModel<BlizzProjectileEntity> projectileModel = new ElementalProjectileModel();

    public BlizzRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new BlizzModel(), 0.5f);
    }

    public void render(BlizzEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected int getBlockLightLevel(BlizzEntity entityIn, BlockPos partialTicks) {
        return entityIn.isAngry() ? 7 : super.func_225624_a_((Entity)entityIn, partialTicks);
    }

    public ResourceLocation getTextureLocation(BlizzEntity entity) {
        return entity.isAngry() ? ANGRY_TEXTURE : CALM_TEXTURE;
    }

    public static Vector3d[] getGaussOffsets(int num, float horzScale, float yScale) {
        Random rand = new Random(69420L);
        Vector3d[] offsets = new Vector3d[num];
        for (int i = 0; i < num; ++i) {
            offsets[i] = new Vector3d(rand.nextGaussian() * (double)horzScale, (double)(rand.nextFloat() * yScale), 0.0).func_178785_b((float)Math.PI * rand.nextFloat());
        }
        return offsets;
    }
}

