/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.BrewerRecipe;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.RecipePrintingUtil;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Brewer")
@IRecipeHandler.For(value=BrewerRecipe.class)
public class CRTBrewerManager
implements IRecipeManager,
IRecipeHandler<BrewerRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IFluidStack output, IIngredientWithAmount ingredient, CTFluidIngredient fluidInput, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(ingredient).input(fluidInput).output(output);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)crtRecipe.recipe(BrewerRecipe::new)));
    }

    public IRecipeType<BrewerRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_BREWER;
    }

    public void removeRecipe(IIngredient output) {
        throw new IllegalArgumentException("The Brewer only outputs fluids! Please provide an IFluidStack");
    }

    @ZenCodeType.Method
    public void removeRecipe(IFluidStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput((IRecipeManager)this, new IFluidStack[]{output}));
    }

    public String dumpToCommandString(IRecipeManager manager, BrewerRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", %s, %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), RecipePrintingUtil.stringifyFluidStacks(recipe.getOutputFluids(), (String)" | "), RecipePrintingUtil.stringifyIngredients(recipe.getInputItems(), (String)" | "), CRTHelper.stringifyFluidIngredients(recipe.getInputFluids()), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, BrewerRecipe>> replaceIngredients(IRecipeManager manager, BrewerRecipe recipe, List<IReplacementRule> rules) throws IRecipeHandler.ReplacementNotSupportedException {
        return ReplacementHandlerHelper.replaceIngredientList(recipe.getInputItems(), Ingredient.class, (IRecipe)recipe, rules, newIngredients -> id -> new CRTRecipe((ResourceLocation)id).energy(recipe.getEnergy()).setInputItems((List<Ingredient>)newIngredients).setInputFluids(recipe.getInputFluids()).setOutputFluids(recipe.getOutputFluids()).recipe(BrewerRecipe::new));
    }
}

