/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.IFluidContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.item.BlockItemAugmentable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidCellBlockItem
extends BlockItemAugmentable
implements IFluidContainerItem {
    public FluidCellBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.setEnchantability(5);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((ITextComponent)StringHelper.getFluidName((FluidStack)fluid));
        }
        tooltip.add((ITextComponent)(this.isCreative(stack, ContainerType.FLUID) ? StringHelper.getTextComponent((String)"info.cofh.infinite_source") : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.amount") + ": " + StringHelper.format((long)fluid.getAmount()) + " / " + StringHelper.format((long)this.getCapacity(stack)) + " mB"))));
        if (FluidHelper.hasPotionTag((FluidStack)fluid)) {
            tooltip.add((ITextComponent)StringHelper.getEmptyLine());
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.effects") + ":")));
            FluidHelper.addPotionTooltip((FluidStack)fluid, tooltip);
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"FluidMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"FluidCre");
    }

    public CompoundNBT getOrCreateTankTag(ItemStack container) {
        CompoundNBT blockTag = container.func_190925_c("BlockEntityTag");
        ListNBT tanks = blockTag.func_150295_c("TankInv", 10);
        if (tanks.isEmpty()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Tank", (byte)0);
            new FluidStorageCoFH(32000).write(tag);
            tanks.add((Object)tag);
            blockTag.func_218657_a("TankInv", (INBT)tanks);
        }
        return tanks.func_150305_b(0);
    }

    public FluidStack getFluid(ItemStack container) {
        CompoundNBT tag = this.getOrCreateTankTag(container);
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)tag);
    }

    public int getCapacity(ItemStack container) {
        CompoundNBT tag = this.getOrCreateTankTag(container);
        if (tag == null) {
            return 0;
        }
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"FluidMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)tag.func_74762_e("Capacity") * mod * base));
    }

    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        CompoundNBT containerTag = this.getOrCreateTankTag(container);
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        FluidStorageCoFH tank = new FluidStorageCoFH(32000).setCapacity(this.getCapacity(container)).read(containerTag);
        if (this.isCreative(container, ContainerType.FLUID)) {
            if (action.execute()) {
                tank.setFluidStack(new FluidStack(resource, tank.getCapacity()));
                tank.write(containerTag);
            }
            return resource.getAmount();
        }
        int ret = tank.fill(resource, action);
        tank.write(containerTag);
        return ret;
    }

    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        CompoundNBT containerTag = this.getOrCreateTankTag(container);
        FluidStorageCoFH tank = new FluidStorageCoFH(32000).setCapacity(this.getCapacity(container)).read(containerTag);
        if (this.isCreative(container, ContainerType.FLUID)) {
            return new FluidStack(tank.getFluidStack(), maxDrain);
        }
        FluidStack ret = tank.drain(maxDrain, action);
        tank.write(containerTag);
        return ret;
    }

    @Override
    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.func_196082_o().func_218657_a("Properties", (INBT)new CompoundNBT());
        for (ItemStack augment : augments) {
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        int fluidExcess = this.getFluidAmount(container) - this.getCapacity(container);
        if (fluidExcess > 0) {
            this.drain(container, fluidExcess, IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

