/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.tileentity;

import cofh.core.tileentity.TileCoFH;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.ThermalTileAugmentable;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.LazyOptional;

public abstract class DynamoTileBase
extends ThermalTileAugmentable
implements ITickableTileEntity {
    protected Direction facing;
    protected int fuel;
    protected int fuelMax;
    protected int coolant;
    protected int coolantMax;
    protected int baseProcessTick;
    protected int processTick;
    protected int minProcessTick;
    protected float energyMod;

    public DynamoTileBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.processTick = this.baseProcessTick = this.getBaseProcessTick();
        this.minProcessTick = this.processTick / 10;
        this.energyMod = 1.0f;
        this.energyStorage = new EnergyStorageCoFH(this.getBaseEnergyStorage(), 0, this.getBaseEnergyXfer()){

            public boolean canExtract() {
                return false;
            }
        };
    }

    @Override
    protected int getBaseEnergyStorage() {
        return this.getBaseProcessTick() * 100;
    }

    public TileCoFH worldContext(BlockState state, IBlockReader world) {
        this.facing = (Direction)state.func_177229_b((Property)Constants.FACING_ALL);
        this.updateHandlers();
        return this;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateFacing();
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canProcessFinish()) {
                this.processFinish();
                if (!this.redstoneControl.getState() || !this.canProcessStart()) {
                    this.isActive = false;
                } else {
                    this.processStart();
                }
            }
        } else if (Utils.timeCheckQuarter((World)this.field_145850_b)) {
            if (this.redstoneControl.getState() && this.canProcessStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            } else {
                this.energyStorage.modify(-this.minProcessTick);
            }
        }
        this.updateActiveState(curActive);
    }

    protected abstract boolean canProcessStart();

    protected boolean canProcessFinish() {
        return this.fuel <= 0;
    }

    protected abstract void processStart();

    protected void processFinish() {
    }

    protected int processTick() {
        if (this.fuel <= 0) {
            return 0;
        }
        int energy = this.calcEnergy();
        this.energyStorage.modify(energy);
        this.fuel -= energy;
        this.transferRF();
        return energy;
    }

    protected int calcEnergy() {
        return Math.min(this.processTick, this.minProcessTick + (int)((double)this.processTick * (1.0 - this.energyStorage.getRatio())));
    }

    protected void transferRF() {
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (Direction)this.getFacing());
        if (adjTile != null) {
            Direction opposite = this.getFacing().func_176734_d();
            int maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            adjTile.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), opposite).ifPresent(e -> this.energyStorage.modify(-e.receiveEnergy(maxTransfer, false)));
        }
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            this.updateFacing();
        }
        return this.facing;
    }

    protected void updateFacing() {
        this.facing = (Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_ALL);
        this.updateHandlers();
    }

    @Override
    public int getCurSpeed() {
        return this.isActive ? this.calcEnergy() : 0;
    }

    @Override
    public int getMaxSpeed() {
        return this.baseProcessTick;
    }

    @Override
    public double getEfficiency() {
        if (this.getEnergyMod() <= 0.0f) {
            return Double.MIN_VALUE;
        }
        return this.getEnergyMod();
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.fuelMax <= 0 || this.fuel <= 0) {
            return 0;
        }
        return scale * this.fuel / this.fuelMax;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.fuelMax);
        buffer.writeInt(this.fuel);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.fuelMax = buffer.readInt();
        this.fuel = buffer.readInt();
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.fuelMax = nbt.func_74762_e("FuelMax");
        this.fuel = nbt.func_74762_e("Fuel");
        this.coolantMax = nbt.func_74762_e("CoolantMax");
        this.coolant = nbt.func_74762_e("Coolant");
        this.processTick = nbt.func_74762_e("ProcTick");
        this.updateHandlers();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.fuelMax);
        nbt.func_74768_a("Fuel", this.fuel);
        nbt.func_74768_a("CoolantMax", this.coolantMax);
        nbt.func_74768_a("Coolant", this.coolant);
        nbt.func_74768_a("ProcTick", this.processTick);
        return nbt;
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        BiPredicate<ItemStack, List<ItemStack>> validator = this.tankInv.hasTanks() ? ThermalAugmentRules.DYNAMO_VALIDATOR : ThermalAugmentRules.DYNAMO_NO_FLUID_VALIDATOR;
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && validator.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        AugmentableHelper.setAttribute((CompoundNBT)this.augmentNBT, (String)"DynamoPower", (float)1.0f);
        this.energyMod = 1.0f;
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)this.augmentNBT, (CompoundNBT)augmentData, (String)"DynamoPower");
        this.energyMod *= AugmentableHelper.getAttributeModWithDefault((CompoundNBT)augmentData, (String)"DynamoEnergy", (float)1.0f);
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        this.creativeEnergy = false;
        super.finalizeAttributes(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        float processMod = AugmentableHelper.getAttributeModWithDefault((CompoundNBT)this.augmentNBT, (String)"DynamoPower", (float)1.0f);
        float totalMod = baseMod * processMod;
        this.energyStorage.applyModifiers(totalMod, totalMod);
        this.baseProcessTick = Math.round((float)this.getBaseProcessTick() * totalMod);
        this.energyMod = MathHelper.clamp((float)this.energyMod, (float)Constants.AUG_SCALE_MIN, (float)Constants.AUG_SCALE_MAX);
        this.processTick = this.baseProcessTick;
        this.minProcessTick = this.baseProcessTick / 10;
    }

    protected final float getEnergyMod() {
        return this.energyMod;
    }

    @Override
    protected <T> LazyOptional<T> getEnergyCapability(@Nullable Direction side) {
        if (side == null || side.equals((Object)this.getFacing())) {
            return super.getEnergyCapability(side);
        }
        return LazyOptional.empty();
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        return super.getItemHandlerCapability(side);
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        return super.getFluidHandlerCapability(side);
    }
}

