/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MachineCatalystSerializer<T extends ThermalCatalyst>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    protected final IFactory<T> factory;

    public MachineCatalystSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        float primaryMod = 1.0f;
        float secondaryMod = 1.0f;
        float energyMod = 1.0f;
        float minChance = 0.0f;
        float useChance = 1.0f;
        Ingredient ingredient = RecipeJsonUtils.parseIngredient((JsonElement)json.get("ingredient"));
        if (json.has("primary_mod")) {
            primaryMod = json.get("primary_mod").getAsFloat();
        }
        if (json.has("secondary_mod")) {
            secondaryMod = json.get("secondary_mod").getAsFloat();
        }
        if (json.has("energy_mod")) {
            energyMod = json.get("energy_mod").getAsFloat();
        }
        if (json.has("min_chance")) {
            minChance = json.get("min_chance").getAsFloat();
        }
        if (json.has("use_chance")) {
            useChance = json.get("use_chance").getAsFloat();
        }
        return this.factory.create(recipeId, ingredient, primaryMod, secondaryMod, energyMod, minChance, useChance);
    }

    @Nullable
    public T fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        float primaryMod = buffer.readFloat();
        float secondaryMod = buffer.readFloat();
        float energyMod = buffer.readFloat();
        float minChance = buffer.readFloat();
        float useChance = buffer.readFloat();
        return this.factory.create(recipeId, ingredient, primaryMod, secondaryMod, energyMod, minChance, useChance);
    }

    public void toNetwork(PacketBuffer buffer, T recipe) {
        ((ThermalCatalyst)((Object)recipe)).ingredient.func_199564_a(buffer);
        buffer.writeFloat(((ThermalCatalyst)((Object)recipe)).primaryMod);
        buffer.writeFloat(((ThermalCatalyst)((Object)recipe)).secondaryMod);
        buffer.writeFloat(((ThermalCatalyst)((Object)recipe)).energyMod);
        buffer.writeFloat(((ThermalCatalyst)((Object)recipe)).minChance);
        buffer.writeFloat(((ThermalCatalyst)((Object)recipe)).useChance);
    }

    public static interface IFactory<T extends ThermalCatalyst> {
        public T create(ResourceLocation var1, Ingredient var2, float var3, float var4, float var5, float var6, float var7);
    }
}

