/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.world;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandler;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandlerRegistry;

public class BlockBreakHandlerRegistry
implements IBlockBreakHandlerRegistry {
    private static BlockBreakHandlerRegistry INSTANCE = new BlockBreakHandlerRegistry();
    private final Multimap<Block, IBlockBreakHandler> handlers = Multimaps.newSetMultimap((Map)Maps.newIdentityHashMap(), Sets::newIdentityHashSet);

    private BlockBreakHandlerRegistry() {
    }

    public static BlockBreakHandlerRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public IBlockBreakHandler register(Block block, IBlockBreakHandler breakAction) {
        this.handlers.put((Object)block, (Object)breakAction);
        return breakAction;
    }

    @Override
    public Collection<IBlockBreakHandler> getHandlers() {
        return Collections.unmodifiableCollection(this.handlers.values());
    }

    @Override
    public Collection<IBlockBreakHandler> getHandlers(Block block) {
        return Collections.unmodifiableCollection(this.handlers.get((Object)block));
    }

    @Override
    @Nullable
    public IBlockBreakHandler getHandler(BlockState blockState, World world, BlockPos pos, PlayerEntity player) {
        for (IBlockBreakHandler breakHandler : this.getHandlers(blockState.func_177230_c())) {
            if (!breakHandler.shouldApply(blockState, world, pos, player)) continue;
            return breakHandler;
        }
        return null;
    }
}

