/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.world;

import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandler;

public class BlockBreakHandlerShulkerBox
implements IBlockBreakHandler {
    @Override
    public boolean shouldApply(BlockState blockState, World world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getDrops(BlockState blockState, World world, BlockPos pos, PlayerEntity player) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, ShulkerBoxTileEntity.class).map(tile -> {
            if (!tile.func_191420_l()) {
                ItemStack itemStack = ShulkerBoxBlock.func_190953_b((DyeColor)tile.func_190592_s());
                CompoundNBT compoundnbt = tile.func_190580_f(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    itemStack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
                if (tile.func_145818_k_()) {
                    itemStack.func_200302_a(tile.func_200200_C_());
                }
                NonNullList list = NonNullList.func_191196_a();
                list.add((Object)itemStack);
                return list;
            }
            return NonNullList.func_191196_a();
        }).orElseGet(NonNullList::func_191196_a);
    }

    @Override
    public void breakBlock(BlockState blockState, World world, BlockPos pos, PlayerEntity player) {
        TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, ShulkerBoxTileEntity.class).ifPresent(LockableLootTileEntity::func_174888_l);
        blockState.func_177230_c().removedByPlayer(blockState, world, pos, player, false, world.func_204610_c(pos));
    }
}

