/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import com.google.common.base.Strings;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.ICommandSource;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ChatEventHandler
implements EventHandlerManager.EventHandler {
    @SubscribeEvent
    public void invoke(ClientChatReceivedEvent event) {
        if (event.getMessage() != null) {
            try {
                String text = event.getMessage().getString();
                if (!Strings.isNullOrEmpty((String)text)) {
                    WaypointParser.parseChatForWaypoints(event, text);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
    }

    @SubscribeEvent
    public void onChatEvent(ClientChatEvent event) {
        String message = event.getMessage();
        if (message.regionMatches(0, "/jm", 0, 3)) {
            if (message.length() > 3) {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                message = message.substring(4);
                EventHandlerManager.clientCommandInvoker.execute((ICommandSource)player, message.split(" "));
            } else {
                String commands = EventHandlerManager.clientCommandInvoker.getPossibleCommands();
                String text = "Available sub commands are: " + commands;
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(text), Util.field_240973_b_);
            }
            event.setCanceled(true);
        }
    }
}

