/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.math.BigDecimal;
import journeymap.client.Constants;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.SliderButton;
import journeymap.common.properties.config.FloatField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;

public class FloatSliderButton
extends Button
implements IConfigFieldHolder<FloatField>,
SliderButton {
    public String prefix = "";
    public boolean dragging = false;
    public float minValue = 0.0f;
    public float maxValue = 0.0f;
    public String suffix = "";
    public boolean drawString = true;
    private float incrementValue = 0.1f;
    private int precision = 2;
    FloatField field;

    public FloatSliderButton(FloatField field, String prefix, String suf) {
        this(field, prefix, suf, field.getMinValue(), field.getMaxValue());
    }

    public FloatSliderButton(FloatField field, String prefix, String suf, float minVal, float maxVal) {
        this(field, prefix, suf, minVal, maxVal, field.getIncrementValue(), field.getPrecision());
    }

    public FloatSliderButton(FloatField field, String prefix, String suf, float minVal, float maxVal, float incrementValue, int precision) {
        super(prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get().floatValue());
        this.disabledLabelColor = 0x404040;
        this.incrementValue = incrementValue;
        this.precision = precision;
    }

    protected int func_230989_a_(boolean p_getYImage_1_) {
        return 0;
    }

    protected void func_230441_a_(MatrixStack mStack, Minecraft mc, int mouseX, int mouseY) {
        mc.func_110434_K().func_110577_a(field_230687_i_);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double sliderValue = this.getSliderValue();
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_230687_i_, (int)(this.field_230690_l_ + 1 + (int)(sliderValue * (double)(this.field_230688_j_ - 10))), (int)(this.field_230691_m_ + 1), (int)0, (int)66, (int)8, (int)(this.field_230689_k_ - 2), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.func_230927_p_());
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.field_230694_p_ && this.isEnabled() && this.func_231047_b_(mouseX, mouseY) && this.dragging) {
            this.setValueFromMouse(mouseX);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double sliderValue = this.getSliderValue();
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_230687_i_, (int)(this.field_230690_l_ + 1 + (int)(sliderValue * (double)(this.field_230688_j_ - 10))), (int)(this.field_230691_m_ + 1), (int)0, (int)66, (int)8, (int)(this.field_230689_k_ - 2), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.func_230927_p_());
            if (this.clickListeners != null) {
                this.checkClickListeners();
            }
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY)) {
            this.dragging = true;
            this.setValueFromMouse(mouseX);
            this.checkClickListeners();
            return true;
        }
        return false;
    }

    public double getSliderValue() {
        return (this.field.get().floatValue() - this.minValue) / (this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        float val = (float)sliderValue * (this.maxValue - this.minValue) + this.minValue;
        this.setValue(val);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            this.func_238482_a_((ITextComponent)Constants.getStringTextComponent(this.prefix + this.field.get() + this.suffix));
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        this.field.save();
        this.checkClickListeners();
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.func_78256_a(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    public boolean func_231046_a_(int key, int value, int modifier) {
        if (this.isEnabled()) {
            if (key == 263 || key == 264 || key == 45) {
                this.setValue(Math.max(this.minValue, this.getValue() - this.incrementValue));
                return true;
            }
            if (key == 262 || key == 265 || key == 61) {
                this.setValue(Math.min(this.maxValue, this.getValue() + this.incrementValue));
                return true;
            }
        }
        return false;
    }

    public float getValue() {
        return this.field.get().floatValue();
    }

    public void setValue(float value) {
        float roundedValue = new BigDecimal(value).setScale(this.precision, 4).floatValue();
        roundedValue = Math.min(roundedValue, this.maxValue);
        roundedValue = Math.max(roundedValue, this.minValue);
        if (this.field.get().floatValue() != roundedValue) {
            this.field.set(Float.valueOf(roundedValue));
            if (!this.dragging) {
                this.field.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get().floatValue());
    }

    @Override
    public FloatField getConfigField() {
        return this.field;
    }
}

