/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.world;

import java.util.ArrayList;
import java.util.List;
import journeymap.client.world.listener.WorldRenderEventListener;

public class CustomListeners {
    private static CustomListeners INSTANCE;
    private final List<WorldRenderEventListener> worldRenderListeners = new ArrayList<WorldRenderEventListener>();

    private CustomListeners() {
    }

    public static CustomListeners getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomListeners();
        }
        return INSTANCE;
    }

    public List<WorldRenderEventListener> getWorldRenderEventListeners() {
        return this.worldRenderListeners;
    }

    public void notifyWorldEventListeners(int sectionX, int sectionY, int sectionZ) {
        this.worldRenderListeners.forEach(worldListener -> worldListener.onWorldRenderEvent(sectionX, sectionY, sectionZ));
    }

    public void removeWorldRenderEventListener(WorldRenderEventListener listener) {
        this.worldRenderListeners.remove(listener);
    }

    public void addWorldRenderEventListener(WorldRenderEventListener listener) {
        this.worldRenderListeners.add(listener);
    }
}

