/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.transporter;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterVoxelShapes;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.item.addon.EfficiencyAddonItem;
import com.buuz135.industrial.item.addon.SpeedAddonItem;
import com.buuz135.industrial.proxy.network.TransporterSyncMessage;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.network.Message;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransporterType
implements INBTSerializable<CompoundNBT> {
    private IBlockContainer container;
    private TransporterTypeFactory factory;
    private Direction side;
    private TransporterTypeFactory.TransporterAction action;
    private ItemStack speed;
    private ItemStack efficiency;

    public TransporterType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        this.container = container;
        this.factory = factory;
        this.side = side;
        this.action = action;
        this.speed = ItemStack.field_190927_a;
        this.efficiency = ItemStack.field_190927_a;
    }

    public boolean onUpgradeActivated(PlayerEntity player, Hand hand) {
        ItemStack handStack = player.func_184586_b(hand);
        if (!handStack.func_190926_b()) {
            if (this.efficiency.func_190926_b() && handStack.func_77973_b() instanceof EfficiencyAddonItem) {
                this.efficiency = ItemHandlerHelper.copyStackWithSize((ItemStack)handStack, (int)1);
                handStack.func_190918_g(1);
                return true;
            }
            if (this.speed.func_190926_b() && handStack.func_77973_b() instanceof SpeedAddonItem) {
                this.speed = ItemHandlerHelper.copyStackWithSize((ItemStack)handStack, (int)1);
                handStack.func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((IItemProvider)this.getFactory().getUpgradeItem(), 1));
        if (!this.efficiency.func_190926_b()) {
            drops.add(this.efficiency);
        }
        if (!this.speed.func_190926_b()) {
            drops.add(this.speed);
        }
        return drops;
    }

    public IBlockContainer getContainer() {
        return this.container;
    }

    public World getWorld() {
        return this.getContainer().getBlockWorld();
    }

    public BlockPos getPos() {
        return this.getContainer().getBlockPosition();
    }

    public TransporterTypeFactory getFactory() {
        return this.factory;
    }

    public Direction getSide() {
        return this.side;
    }

    public TransporterTypeFactory.TransporterAction getAction() {
        return this.action;
    }

    public void update() {
    }

    public void updateClient() {
    }

    public void handleEntity(Entity entity) {
    }

    public void onUpgradeRemoved() {
    }

    public int getRedstoneOutput() {
        return 0;
    }

    public VoxelShape getBorderBoundingBox() {
        switch (this.side) {
            case DOWN: {
                return TransporterVoxelShapes.DOWN_RING;
            }
            case NORTH: {
                return TransporterVoxelShapes.NORTH_RING;
            }
            case EAST: {
                return TransporterVoxelShapes.EAST_RING;
            }
            case SOUTH: {
                return TransporterVoxelShapes.SOUTH_RING;
            }
            case WEST: {
                return TransporterVoxelShapes.WEST_RING;
            }
            case UP: {
                return TransporterVoxelShapes.UP_RING;
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape getCenterBoundingBox() {
        if (this.action == TransporterTypeFactory.TransporterAction.EXTRACT) {
            switch (this.side) {
                case DOWN: {
                    return TransporterVoxelShapes.DOWN_MIDDLE_EXTRACT;
                }
                case NORTH: {
                    return TransporterVoxelShapes.NORTH_MIDDLE_EXTRACT;
                }
                case EAST: {
                    return TransporterVoxelShapes.EAST_MIDDLE_EXTRACT;
                }
                case SOUTH: {
                    return TransporterVoxelShapes.SOUTH_MIDDLE_EXTRACT;
                }
                case WEST: {
                    return TransporterVoxelShapes.WEST_MIDDLE_EXTRACT;
                }
                case UP: {
                    return TransporterVoxelShapes.UP_MIDDLE_EXTRACT;
                }
            }
        }
        switch (this.side) {
            case DOWN: {
                return TransporterVoxelShapes.DOWN_MIDDLE_INSERT;
            }
            case NORTH: {
                return TransporterVoxelShapes.NORTH_MIDDLE_INSERT;
            }
            case EAST: {
                return TransporterVoxelShapes.EAST_MIDDLE_INSERT;
            }
            case SOUTH: {
                return TransporterVoxelShapes.SOUTH_MIDDLE_INSERT;
            }
            case WEST: {
                return TransporterVoxelShapes.WEST_MIDDLE_INSERT;
            }
            case UP: {
                return TransporterVoxelShapes.UP_MIDDLE_INSERT;
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public boolean hasGui() {
        return true;
    }

    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
    }

    public void handleRenderSync(Direction origin, CompoundNBT compoundNBT) {
    }

    public void syncRender(Direction origin, CompoundNBT compoundNBT) {
        IndustrialForegoing.NETWORK.sendToNearby(this.getWorld(), this.getPos(), 32, (Message)new TransporterSyncMessage(this.getPos(), compoundNBT, this.getSide().func_176745_a(), origin.func_176745_a()));
    }

    public void addComponentsToGui(List<IGuiComponent> componentList) {
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TextureGuiComponent(158, 4, 14, 14, res, 96, 233, new String[0]){

            @Override
            @Nullable
            public List<ITextComponent> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
                ArrayList<ITextComponent> components = new ArrayList<ITextComponent>();
                if (!TransporterType.this.speed.func_190926_b()) {
                    components.add(TransporterType.this.speed.func_200301_q());
                }
                if (!TransporterType.this.efficiency.func_190926_b()) {
                    components.add(TransporterType.this.efficiency.func_200301_q());
                }
                if (components.isEmpty()) {
                    components.add((ITextComponent)new StringTextComponent("No Addons"));
                }
                return components;
            }
        });
    }

    public boolean ignoresCollision() {
        return false;
    }

    public void toggleAction() {
        this.action = this.action == TransporterTypeFactory.TransporterAction.EXTRACT ? TransporterTypeFactory.TransporterAction.INSERT : TransporterTypeFactory.TransporterAction.EXTRACT;
        this.getContainer().requestSync();
        if (this.getWorld().field_72995_K && this.getContainer() instanceof TileEntity) {
            ModelDataManager.requestModelDataRefresh((TileEntity)((TileEntity)this.getContainer()));
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74757_a("Insert", this.action == TransporterTypeFactory.TransporterAction.INSERT);
        compoundNBT.func_218657_a("Efficiency", (INBT)this.efficiency.serializeNBT());
        compoundNBT.func_218657_a("Speed", (INBT)this.speed.serializeNBT());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.action = nbt.func_74767_n("Insert") ? TransporterTypeFactory.TransporterAction.INSERT : TransporterTypeFactory.TransporterAction.EXTRACT;
        this.speed = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Speed"));
        this.efficiency = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Efficiency"));
    }

    public float getSpeed() {
        return this.speed.func_190926_b() ? 1.0f : AugmentWrapper.getType((ItemStack)this.speed, (IAugmentType)AugmentTypes.SPEED);
    }

    public float getEfficiency() {
        return this.efficiency.func_190926_b() ? 1.0f : (1.0f - AugmentWrapper.getType((ItemStack)this.efficiency, (IAugmentType)AugmentTypes.EFFICIENCY)) / 0.1f * 32.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, MatrixStack stack, int combinedOverlayIn, IRenderTypeBuffer buffer) {
    }
}

