/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage;

import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTable;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class TransporterBlock
extends BasicTileBlock<TransporterTile>
implements IWaterLoggable {
    public TransporterBlock(ItemGroup group) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151574_g, (MaterialColor)MaterialColor.field_151676_q).func_200942_a().func_200943_b(2.0f), TransporterTile.class);
        this.setRegistryName("industrialforegoing", "transporter");
        this.setItemGroup(group);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    private static List<VoxelShape> getShapes(BlockState state, IBlockReader source, BlockPos pos, Predicate<TransporterType> filter) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        TileEntity entity = source.func_175625_s(pos);
        if (entity instanceof TransporterTile) {
            for (TransporterType upgrade : ((TransporterTile)entity).getTransporterTypeMap().values()) {
                if (upgrade == null || !filter.test(upgrade)) continue;
                boxes.add(upgrade.getCenterBoundingBox());
                boxes.add(upgrade.getBorderBoundingBox());
            }
        }
        return boxes;
    }

    public IFactory<TransporterTile> getTileEntityFactory() {
        return TransporterTile::new;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TransporterType upgrade;
        Pair<Direction, Boolean> upgradePair;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TransporterTile && target instanceof BlockRayTraceResult && (upgradePair = this.getFacingUpgradeHit(state, player.field_70170_p, pos, player)) != null && (upgrade = ((TransporterTile)tileEntity).getTransporterTypeMap().get(upgradePair.getKey())) != null) {
            return new ItemStack((IItemProvider)upgrade.getFactory().getUpgradeItem(), 1);
        }
        return ItemStack.field_190927_a;
    }

    public Pair<Direction, Boolean> getFacingUpgradeHit(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        VoxelShape hit;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        RayTraceResult result = RayTraceUtils.rayTraceSimple((World)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockRayTraceResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockRayTraceResult)((BlockRayTraceResult)result), (World)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null && tileEntity instanceof TransporterTile) {
            for (Direction direction : ((TransporterTile)tileEntity).getTransporterTypeMap().keySet()) {
                if (VoxelShapes.func_197879_c((VoxelShape)((TransporterTile)tileEntity).getTransporterTypeMap().get(direction).getCenterBoundingBox(), (VoxelShape)hit, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                    return Pair.of((Object)direction, (Object)true);
                }
                if (!VoxelShapes.func_197879_c((VoxelShape)((TransporterTile)tileEntity).getTransporterTypeMap().get(direction).getBorderBoundingBox(), (VoxelShape)hit, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                return Pair.of((Object)direction, (Object)false);
            }
        }
        return null;
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, IBlockReader source, BlockPos pos) {
        return TransporterBlock.getShapes(state, source, pos, conveyorUpgrade -> true);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext p_220053_4_) {
        return TransporterBlock.getShapes(state, world, pos, transporterType -> true).stream().reduce((voxelShape, voxelShape2) -> VoxelShapes.func_197882_b((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElseGet(VoxelShapes::func_197880_a);
    }

    @Nonnull
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (VoxelShape shape1 : TransporterBlock.getShapes(state, world, pos, conveyorUpgrade -> !conveyorUpgrade.ignoresCollision())) {
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)shape1, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        Pair<Direction, Boolean> info;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        ItemStack handStack = player.func_184586_b(hand);
        if (tileEntity instanceof TransporterTile && (info = this.getFacingUpgradeHit(state, worldIn, pos, player)) != null) {
            Direction facing = (Direction)info.getLeft();
            boolean isMiddle = (Boolean)info.getRight();
            if (player.func_225608_bj_() && handStack.func_190926_b()) {
                if (((TransporterTile)tileEntity).hasUpgrade(facing)) {
                    ((TransporterTile)tileEntity).removeUpgrade(facing, true);
                    return ActionResultType.SUCCESS;
                }
            } else if (isMiddle) {
                if (((TransporterTile)tileEntity).hasUpgrade(facing)) {
                    ((TransporterTile)tileEntity).getTransporterTypeMap().get(facing).toggleAction();
                    return ActionResultType.SUCCESS;
                }
            } else if (((TransporterTile)tileEntity).hasUpgrade(facing)) {
                TransporterType transporterType = ((TransporterTile)tileEntity).getTransporterTypeMap().get(facing);
                if (!handStack.func_190926_b() && transporterType.onUpgradeActivated(player, hand)) {
                    return ActionResultType.SUCCESS;
                }
                if (transporterType.hasGui()) {
                    ((TransporterTile)tileEntity).openGui(player, facing);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, hand, ray);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList itemStacks = NonNullList.func_191196_a();
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TransporterTile) {
            ((TransporterTile)tileEntity).getTransporterTypeMap().values().forEach(transporterType -> itemStacks.addAll(transporterType.getDrops()));
        }
        return itemStacks;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }
}

