/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.proxy.client.render.TransporterTESR;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.TileUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransporterItemType
extends FilteredTransporterType<ItemStack, IItemHandler> {
    public static final int QUEUE_SIZE = 6;
    private HashMap<Direction, List<ItemStack>> queue = new HashMap();
    private int extractSlot = 0;

    public TransporterItemType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).add(0, ItemStack.field_190927_a);
            }
            if (this.queue.size() <= 6) continue;
            this.queue.get(value).remove(this.queue.get(value).size() - 1);
        }
    }

    @Override
    public RegulatorFilter<ItemStack, IItemHandler> createFilter() {
        return new RegulatorFilter<ItemStack, IItemHandler>(20, 20, 5, 3, 16, 64, 8192, ""){

            @Override
            public int matches(ItemStack stack, IItemHandler itemHandler, boolean isRegulated) {
                if (this.isEmpty()) {
                    return stack.func_190916_E();
                }
                int amount = 0;
                if (isRegulated) {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        if (!itemHandler.getStackInSlot(i).func_77969_a(stack)) continue;
                        amount += itemHandler.getStackInSlot(i).func_190916_E();
                    }
                }
                for (IFilter.GhostSlot slot : this.getFilter()) {
                    if (!stack.func_77969_a(slot.getStack())) continue;
                    int maxAmount = isRegulated ? slot.getAmount() : Integer.MAX_VALUE;
                    int returnAmount = Math.min(stack.func_190916_E(), maxAmount - amount);
                    if (returnAmount <= 0) continue;
                    return returnAmount;
                }
                return 0;
            }
        };
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (!this.getWorld().field_72995_K && (float)this.getWorld().func_82737_E() % Math.max(1.0f, 4.0f - speed) == 0.0f) {
            IBlockContainer container = this.getContainer();
            if (this.getAction() == TransporterTypeFactory.TransporterAction.EXTRACT && container instanceof TransporterTile) {
                for (Direction direction : ((TransporterTile)container).getTransporterTypeMap().keySet()) {
                    TransporterType transporterType = ((TransporterTile)container).getTransporterTypeMap().get(direction);
                    if (!(transporterType instanceof TransporterItemType) || transporterType.getAction() != TransporterTypeFactory.TransporterAction.INSERT) continue;
                    TileUtil.getTileEntity((IBlockReader)this.getWorld(), (BlockPos)this.getPos().func_177972_a(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d()).ifPresent(origin -> TileUtil.getTileEntity((IBlockReader)this.getWorld(), (BlockPos)this.getPos().func_177972_a(direction)).ifPresent(otherTile -> otherTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).ifPresent(destination -> {
                        if (this.extractSlot >= origin.getSlots() || origin.getStackInSlot(this.extractSlot).func_190926_b() || !this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false) || !this.filter(((TransporterItemType)transporterType).getFilter(), ((TransporterItemType)transporterType).isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated())) {
                            this.findSlot((IItemHandler)origin, ((TransporterItemType)transporterType).getFilter(), ((TransporterItemType)transporterType).isWhitelist(), (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated());
                        }
                        if (this.extractSlot >= origin.getSlots()) {
                            return;
                        }
                        if (!origin.getStackInSlot(this.extractSlot).func_190926_b()) {
                            int amount = (int)(1.0f * this.getEfficiency());
                            ItemStack extracted = origin.extractItem(this.extractSlot, amount, true);
                            int simulatedAmount = ((TransporterItemType)transporterType).getFilter().matches(extracted, (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated());
                            if (!extracted.func_190926_b() && this.filter(this.getFilter(), this.isWhitelist(), extracted, (IItemHandler)origin, false) && this.filter(((TransporterItemType)transporterType).getFilter(), ((TransporterItemType)transporterType).isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated()) && simulatedAmount > 0) {
                                ItemStack returned = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)extracted, (boolean)true);
                                if (returned.func_190926_b() || amount - returned.func_190916_E() > 0) {
                                    extracted = origin.extractItem(this.extractSlot, returned.func_190926_b() ? simulatedAmount : simulatedAmount - returned.func_190916_E(), false);
                                    ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)extracted, (boolean)false);
                                    ((TransporterItemType)transporterType).addTransferedStack(this.getSide(), extracted);
                                } else {
                                    ++this.extractSlot;
                                    if (this.extractSlot >= origin.getSlots()) {
                                        this.extractSlot = 0;
                                    }
                                }
                            }
                        }
                        container.requestSync();
                    }))));
                }
            }
        }
    }

    private boolean filter(RegulatorFilter<ItemStack, IItemHandler> filter, boolean whitelist, ItemStack stack, IItemHandler handler, boolean isRegulated) {
        int accepts = filter.matches(stack, handler, isRegulated);
        if (whitelist && filter.isEmpty()) {
            return false;
        }
        return filter.isEmpty() != (whitelist == accepts > 0);
    }

    @Override
    public void updateClient() {
        super.updateClient();
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).add(0, ItemStack.field_190927_a);
            }
            this.queue.get(value).add(0, ItemStack.field_190927_a);
            while (this.queue.get(value).size() > 6) {
                this.queue.get(value).remove(this.queue.get(value).size() - 1);
            }
        }
    }

    private void findSlot(IItemHandler itemHandler, RegulatorFilter<ItemStack, IItemHandler> otherFilter, boolean otherWhitelist, IItemHandler otherItemHandler, boolean otherRegulated) {
        for (int i = this.extractSlot; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).func_190926_b() || !this.filter(this.getFilter(), this.isWhitelist(), itemHandler.getStackInSlot(i), itemHandler, false) || !this.filter(otherFilter, otherWhitelist, itemHandler.getStackInSlot(i), otherItemHandler, otherRegulated)) continue;
            this.extractSlot = i;
            return;
        }
        this.extractSlot = 0;
    }

    public void addTransferedStack(Direction direction, ItemStack stack) {
        this.syncRender(direction, stack.serializeNBT());
    }

    @Override
    public void handleRenderSync(Direction origin, CompoundNBT compoundNBT) {
        this.queue.computeIfAbsent(origin, direction -> new ArrayList()).add(0, ItemStack.func_199557_a((CompoundNBT)compoundNBT));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, MatrixStack stack, int combinedOverlayIn, IRenderTypeBuffer buffer) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer);
        if (step < this.queue.computeIfAbsent(direction, v -> new ArrayList()).size()) {
            float scale = 0.1f;
            stack.func_227862_a_(scale, scale, scale);
            ItemStack itemStack = this.queue.get(direction).get(step);
            if (!itemStack.func_190926_b()) {
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.NONE, 0xF000F0, combinedOverlayIn, stack, buffer);
            } else {
                stack.func_227860_a_();
                stack.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                IVertexBuilder buffer1 = buffer.getBuffer(TransporterTESR.TYPE);
                Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
                float pX1 = 1.0f;
                float u = 1.0f;
                float pX2 = 0.0f;
                float u2 = 0.0f;
                Color CLOSE = Color.CYAN;
                Color FAR = new Color(6815999);
                double ratio = ((double)step + 2.5) / 6.0;
                float xOffset = -0.75f;
                float yOffset = -0.0f;
                float zOffset = -0.75f;
                int alpha = 512;
                stack.func_227862_a_(0.25f, 0.25f, 0.25f);
                int red = (int)Math.abs(ratio * (double)FAR.getRed() + (1.0 - ratio) * (double)CLOSE.getRed());
                int green = (int)Math.abs(ratio * (double)FAR.getGreen() + (1.0 - ratio) * (double)CLOSE.getGreen());
                int blue = (int)Math.abs(ratio * (double)FAR.getBlue() + (1.0 - ratio) * (double)CLOSE.getBlue());
                buffer1.func_227888_a_(matrix, pX2 + xOffset, yOffset, 0.0f + zOffset).func_225583_a_(u2, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
                buffer1.func_227888_a_(matrix, pX1 + xOffset + 0.5f, yOffset, 0.0f + zOffset).func_225583_a_(u, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
                buffer1.func_227888_a_(matrix, pX1 + xOffset + 0.5f, yOffset, 1.5f + zOffset).func_225583_a_(u, 1.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
                buffer1.func_227888_a_(matrix, pX2 + xOffset, yOffset, 1.5f + zOffset).func_225583_a_(u2, 1.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
                stack.func_227865_b_();
            }
        }
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            this.setRegistryName("item");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterItemType(container, this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return new ResourceLocation("industrialforegoing", "block/transporters/item_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("industrialforegoing:blocks/transporters/item"), new ResourceLocation("industrialforegoing:blocks/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(World world, BlockPos pos, Direction face) {
            return TileUtil.getTileEntity((IBlockReader)world, (BlockPos)pos).map(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent()).orElse(false);
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "block/transporters/item_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.func_176610_l().toLowerCase());
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem(), (int)2).func_200472_a("IPI").func_200472_a("GMG").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151079_bi).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_221602_aD).func_200464_a(consumer);
        }
    }
}

