/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.buuz135.industrial.utils.NumberUtils;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class SlotDefinitionGuiAddon
extends BasicButtonAddon {
    private int slotId;

    public SlotDefinitionGuiAddon(ButtonComponent buttonComponent, int slotId) {
        super(buttonComponent);
        this.slotId = slotId;
    }

    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (!this.getItemStack().func_190926_b() && this.getItemStack().func_77942_o()) {
            BackpackDataManager.SlotDefinition display;
            BackpackDataManager.BackpackItemHandler handler = BackpackDataManager.CLIENT_SIDE_BACKPACKS.getOrDefault(this.getItemStack().func_77978_p().func_74779_i("Id"), null);
            AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.SLOT), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
            if (handler != null && !(display = handler.getSlotDefinition(this.slotId)).getStack().func_190926_b()) {
                Minecraft.func_71410_x().func_175599_af().func_175042_a(display.getStack(), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                stack.func_227860_a_();
                stack.func_227861_a_(0.0, 0.0, 260.0);
                stack.func_227862_a_(0.5f, 0.5f, 0.5f);
                String amount = NumberUtils.getFormatedBigNumber(display.getAmount());
                Minecraft.func_71410_x().field_71466_p.func_238405_a_(stack, amount, ((float)(guiX + this.getPosX() + 17) - (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(amount) / 2.0f) * 2.0f, (float)((guiY + this.getPosY() + 13) * 2), 0xFFFFFF);
                stack.func_227865_b_();
            }
        }
    }

    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.isInside(screen, mouseX - guiX, mouseY - guiY)) {
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 256.0);
            AssetUtil.drawSelectingOverlay((MatrixStack)stack, (int)(this.getPosX() + 1), (int)(this.getPosY() + 1), (int)(this.getPosX() + this.getXSize() - 1), (int)(this.getPosY() + this.getYSize() - 1));
            stack.func_227865_b_();
        }
    }

    public void handleClick(Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        if (screen instanceof ContainerScreen && ((ContainerScreen)screen).func_212873_a_() instanceof ILocatable) {
            ILocatable locatable = (ILocatable)((ContainerScreen)screen).func_212873_a_();
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74778_a("Id", this.getItemStack().func_77978_p().func_74779_i("Id"));
            compoundNBT.func_74768_a("Slot", this.slotId);
            compoundNBT.func_74768_a("Button", button);
            compoundNBT.func_74757_a("Shift", Screen.func_231173_s_());
            compoundNBT.func_74757_a("Ctrl", Screen.func_231172_r_());
            Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), 4, compoundNBT));
        }
    }

    public abstract ItemStack getItemStack();

    public List<ITextComponent> getTooltipLines() {
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
        BackpackDataManager.BackpackItemHandler handler = BackpackDataManager.CLIENT_SIDE_BACKPACKS.getOrDefault(this.getItemStack().func_77978_p().func_74779_i("Id"), null);
        if (handler != null) {
            BackpackDataManager.SlotDefinition display = handler.getSlotDefinition(this.slotId);
            if (!display.getStack().func_190926_b()) {
                lines.addAll(Minecraft.func_71410_x().field_71462_r.func_231151_a_(display.getStack()));
                lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new DecimalFormat().format(display.getAmount())));
            }
            String changeVoid = TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.tooltip.ctrl_left").getString();
            if (display.isVoidItems()) {
                lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.backpack.void").getString() + TextFormatting.GREEN + new TranslationTextComponent("text.industrialforegoing.display.enabled").getString() + " " + changeVoid));
            } else {
                lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.backpack.void").getString() + TextFormatting.RED + new TranslationTextComponent("text.industrialforegoing.display.disabled").getString() + " " + changeVoid));
            }
            String changeRefill = TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.tooltip.ctrl_right").getString();
            if (display.isRefillItems()) {
                lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.backpack.refill").getString() + TextFormatting.GREEN + new TranslationTextComponent("text.industrialforegoing.display.enabled").getString() + " " + changeRefill));
            } else {
                lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.backpack.refill").getString() + TextFormatting.RED + new TranslationTextComponent("text.industrialforegoing.display.disabled").getString() + " " + changeRefill));
            }
        }
        return lines;
    }
}

