/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.generator;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class MycelialGeneratorCategory
implements IRecipeCategory<MycelialGeneratorRecipe> {
    private IGuiHelper guiHelper;
    private IMycelialGeneratorType type;
    private final IDrawable smallTank;

    public MycelialGeneratorCategory(IMycelialGeneratorType type, IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.type = type;
        this.smallTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 238, 4, 12, 13);
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("industrialforegoing", "mycelial_" + this.type.getName());
    }

    public Class<? extends MycelialGeneratorRecipe> getRecipeClass() {
        return MycelialGeneratorRecipe.class;
    }

    public String getTitle() {
        return new TranslationTextComponent("industrialforegoing.jei.category." + this.type.getName()).getString();
    }

    public IDrawable getBackground() {
        int n = 20 * this.type.getInputs().length + 110;
        Minecraft.func_71410_x().field_71466_p.getClass();
        return this.guiHelper.createBlankDrawable(n, 9 * 3);
    }

    public IDrawable getIcon() {
        return null;
    }

    public IMycelialGeneratorType getType() {
        return this.type;
    }

    public void setIngredients(MycelialGeneratorRecipe recipe, IIngredients iIngredients) {
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                iIngredients.setInputLists(VanillaTypes.ITEM, recipe.getInputItems().stream().map(ingredients -> ingredients.stream().map(ingredient -> Arrays.asList(ingredient.func_193365_a())).flatMap(Collection::stream).collect(Collectors.toList())).collect(Collectors.toList()));
                continue;
            }
            if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
            iIngredients.setInputLists(VanillaTypes.FLUID, recipe.getFluidItems());
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, MycelialGeneratorRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStackGroup = iRecipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStackGroup = iRecipeLayout.getFluidStacks();
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                Minecraft.func_71410_x().field_71466_p.getClass();
                guiItemStackGroup.init(i, true, 20 * i, 9 / 2);
                guiItemStackGroup.set(i, recipe.getInputItems().get(i).stream().map(ingredient -> Arrays.asList(ingredient.func_193365_a())).flatMap(Collection::stream).collect(Collectors.toList()));
                continue;
            }
            if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
            Minecraft.func_71410_x().field_71466_p.getClass();
            guiFluidStackGroup.init(i, true, 20 * i + 3, 3 + 9 / 2, 12, 13, 1000, false, this.smallTank);
            guiFluidStackGroup.set(i, recipe.getFluidItems().get(i));
        }
    }

    public void draw(MycelialGeneratorRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                int finalI = i;
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                Minecraft.func_71410_x().field_71466_p.getClass();
                SlotsScreenAddon.drawAsset((MatrixStack)matrixStack, (Screen)screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)(20 * i), (int)(9 / 2), (int)0, (int)0, (int)1, integer -> Pair.of((Object)1, (Object)1), integer -> ItemStack.field_190927_a, (boolean)true, integer -> new Color(this.type.getInputColors()[finalI].func_196060_f()), integer -> true);
                continue;
            }
            if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            IAsset iAsset = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL);
            Minecraft.func_71410_x().field_71466_p.getClass();
            AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)screen, (IAsset)iAsset, (int)(20 * i), (int)(9 / 2));
        }
        int x = 20 * this.type.getInputs().length + 3;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String string = TextFormatting.DARK_GRAY + "Time: " + TextFormatting.DARK_AQUA + new DecimalFormat().format((double)recipe.getTicks() / 20.0) + TextFormatting.DARK_GRAY + " s";
        float f = x;
        Minecraft.func_71410_x().field_71466_p.getClass();
        fontRenderer.func_238421_b_(matrixStack, string, f, (float)(9 * 0), -1);
        FontRenderer fontRenderer2 = Minecraft.func_71410_x().field_71466_p;
        String string2 = TextFormatting.DARK_GRAY + "Production: " + TextFormatting.DARK_AQUA + recipe.getPowerTick() + TextFormatting.DARK_GRAY + " FE/t";
        float f2 = x;
        Minecraft.func_71410_x().field_71466_p.getClass();
        fontRenderer2.func_238421_b_(matrixStack, string2, f2, (float)(9 * 1), -1);
        FontRenderer fontRenderer3 = Minecraft.func_71410_x().field_71466_p;
        String string3 = TextFormatting.DARK_GRAY + "Total: " + TextFormatting.DARK_AQUA + new DecimalFormat().format(recipe.getTicks() * recipe.getPowerTick()) + TextFormatting.DARK_GRAY + " FE";
        float f3 = x;
        Minecraft.func_71410_x().field_71466_p.getClass();
        fontRenderer3.func_238421_b_(matrixStack, string3, f3, (float)(9 * 2), -1);
    }

    public List<ITextComponent> getTooltipStrings(MycelialGeneratorRecipe recipe, double mouseX, double mouseY) {
        return Collections.emptyList();
    }
}

