/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render;

import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class TransporterTESR
extends TileEntityRenderer<TransporterTile> {
    public static RenderType TYPE = TransporterTESR.createRenderType();

    public TransporterTESR(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static RenderType createRenderType() {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("industrialforegoing", "textures/blocks/transporters/particle.png"), false, false)).func_228726_a_(new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"transporter_render", (VertexFormat)DefaultVertexFormats.field_181709_i, (int)7, (int)262144, (boolean)false, (boolean)true, (RenderType.State)state);
    }

    public static Vector3f getPath(Direction from, Direction to, double step) {
        float totalSteps = 6.15f;
        if (from.func_176734_d() == to) {
            totalSteps = 9.0f;
            Vector3d vector3d = new Vector3d((double)(to.func_229386_k_().func_195899_a() / totalSteps) * step, (double)(to.func_229386_k_().func_195900_b() / totalSteps) * step, (double)(to.func_229386_k_().func_195902_c() / totalSteps) * step);
            if (from.func_176740_k() == Direction.Axis.X) {
                vector3d = vector3d.func_72441_c(0.0, 0.5, 0.5);
                if (from.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.func_72441_c(1.0, 0.0, 0.0);
                }
            }
            if (from.func_176740_k() == Direction.Axis.Z) {
                vector3d = vector3d.func_72441_c(0.5, 0.5, 0.0);
                if (from.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.func_72441_c(0.0, 0.0, 1.0);
                }
            }
            if (from.func_176740_k() == Direction.Axis.Y) {
                vector3d = vector3d.func_72441_c(0.5, 0.0, 0.5);
                if (from.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.func_72441_c(0.0, 1.0, 0.0);
                }
            }
            float divideSecond = -0.22f;
            vector3d = vector3d.func_72441_c((double)(from.func_229386_k_().func_195899_a() * divideSecond), (double)(from.func_229386_k_().func_195900_b() * divideSecond), (double)(from.func_229386_k_().func_195902_c() * divideSecond));
            return new Vector3f(vector3d);
        }
        Vector3f vsrc = from.func_229386_k_();
        Vector3f vdst = to.func_229386_k_();
        Vector3f a = vsrc.func_229195_e_();
        a.func_195898_a(0.3125f);
        Vector3f b = vdst.func_229195_e_();
        b.func_195898_a(0.375f);
        Vector3f c = vsrc.func_229195_e_();
        c.func_195898_a(0.1875f);
        float sind = -MathHelper.func_76126_a((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        float cosd = -MathHelper.func_76134_b((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        a.func_195898_a(sind);
        b.func_195898_a(cosd);
        a.func_229189_a_(b);
        a.func_229189_a_(c);
        float divide = 2.5f;
        a.func_195904_b(vdst.func_195899_a() / divide, vdst.func_195900_b() / divide, vdst.func_195902_c() / divide);
        a.func_195904_b(0.5f, 0.5f, 0.5f);
        float divideSecond = 0.15f;
        a.func_195904_b(vsrc.func_195899_a() * divideSecond, vsrc.func_195900_b() * divideSecond, vsrc.func_195902_c() * divideSecond);
        return a;
    }

    public void render(TransporterTile tile, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        Map<Direction, TransporterType> transporters = tile.getTransporterTypeMap();
        for (Direction direction : transporters.keySet()) {
            if (transporters.get(direction).getAction() != TransporterTypeFactory.TransporterAction.EXTRACT) continue;
            for (Direction other : transporters.keySet()) {
                if (direction == other || !transporters.get(direction).getFactory().getRegistryName().equals((Object)transporters.get(other).getFactory().getRegistryName()) || transporters.get(other).getAction() == TransporterTypeFactory.TransporterAction.EXTRACT) continue;
                for (int i = -1; i < 6; ++i) {
                    stack.func_227860_a_();
                    Vector3f pos = TransporterTESR.getPath(direction, other, (double)((long)i + tile.func_145831_w().func_82737_E() % 2L) + (double)(tile.func_145831_w().func_82737_E() % 3L) / 3.0);
                    stack.func_227861_a_((double)pos.func_195899_a(), (double)pos.func_195900_b(), (double)pos.func_195902_c());
                    transporters.get(other).renderTransfer(pos, direction, i + 1, stack, combinedOverlayIn, buffer);
                    stack.func_227865_b_();
                }
            }
        }
    }
}

