/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TickeableSound
extends LocatableSound
implements ITickableSound {
    private boolean done;
    private World world;
    private int distance;
    private float tickIncrease;

    public TickeableSound(World world, BlockPos pos, SoundEvent soundIn, int distance, int soundTime) {
        super(soundIn, SoundCategory.BLOCKS);
        this.world = world;
        this.field_147660_d = pos.func_177958_n();
        this.field_147661_e = pos.func_177956_o();
        this.field_147658_f = pos.func_177952_p();
        this.field_147659_g = false;
        this.done = false;
        this.field_147662_b = 0.8f;
        this.field_147663_c = 0.0f;
        this.field_217862_m = false;
        this.distance = distance;
        this.tickIncrease = 1.0f / ((float)soundTime * 20.0f);
    }

    public boolean func_147667_k() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public void increase() {
        if (this.field_147663_c < 2.0f) {
            this.field_147663_c += this.tickIncrease;
        }
    }

    public void decrease() {
        if (this.field_147663_c > 0.0f) {
            this.field_147663_c -= this.tickIncrease;
        }
    }

    public void func_73660_a() {
        double distance = Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_218139_n((Vector3i)new BlockPos(this.field_147660_d, this.field_147661_e, this.field_147658_f));
        if (distance > (double)this.distance) {
            this.field_147662_b = 0.0f;
        } else {
            if (distance == 0.0) {
                distance = 1.0;
            }
            this.field_147662_b = (float)(0.8 * (1.0 - distance / (double)this.distance));
        }
    }

    public void setPitch(float pitch) {
        this.field_147663_c = pitch;
    }
}

