/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.worlddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BackpackDataManager
extends WorldSavedData {
    public static HashMap<String, BackpackItemHandler> CLIENT_SIDE_BACKPACKS = new HashMap();
    public static final String NAME = "IFBackpack";
    public static final int SLOT_AMOUNT = 32;
    public HashMap<String, BackpackItemHandler> itemHandlers = new HashMap();

    public BackpackDataManager(String name) {
        super(name);
    }

    public BackpackDataManager() {
        super(NAME);
    }

    public void createBackPack(UUID uuid) {
        this.itemHandlers.put(uuid.toString(), new BackpackItemHandler(this));
        this.func_76185_a();
    }

    public BackpackItemHandler getBackpack(String id) {
        return this.itemHandlers.get(id);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.itemHandlers = new HashMap();
        CompoundNBT backpacks = nbt.func_74775_l("Backpacks");
        for (String s : backpacks.func_150296_c()) {
            BackpackItemHandler hander = new BackpackItemHandler(this);
            hander.deserializeNBT(backpacks.func_74775_l(s));
            this.itemHandlers.put(s, hander);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT nbt = new CompoundNBT();
        this.itemHandlers.forEach((s, iItemHandler) -> nbt.func_218657_a(s, (INBT)iItemHandler.serializeNBT()));
        compound.func_218657_a("Backpacks", (INBT)nbt);
        return compound;
    }

    @Nullable
    public static BackpackDataManager getData(IWorld world) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = ((ServerWorld)world).func_73046_m().func_71218_a(World.field_234918_g_);
            BackpackDataManager data = (BackpackDataManager)serverWorld.func_217481_x().func_215752_a(BackpackDataManager::new, NAME);
            return data;
        }
        return null;
    }

    public static class SlotDefinition
    implements INBTSerializable<CompoundNBT> {
        private ItemStack stack = ItemStack.field_190927_a;
        private int amount = 0;
        private boolean voidItems = true;
        private boolean refillItems = false;
        private BackpackItemHandler parent;

        public SlotDefinition(BackpackItemHandler parent) {
            this.parent = parent;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
            this.parent.markDirty();
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
            this.parent.markDirty();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("Stack", (INBT)this.stack.serializeNBT());
            compoundNBT.func_74768_a("Amount", this.amount);
            compoundNBT.func_74757_a("Void", this.voidItems);
            compoundNBT.func_74757_a("Refill", this.refillItems);
            return compoundNBT;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Stack"));
            this.amount = nbt.func_74762_e("Amount");
            this.voidItems = nbt.func_74767_n("Void");
            this.refillItems = nbt.func_74767_n("Refill");
        }

        public boolean isVoidItems() {
            return this.voidItems;
        }

        public void setVoidItems(boolean voidItems) {
            this.voidItems = voidItems;
            this.parent.markDirty();
        }

        public boolean isRefillItems() {
            return this.refillItems;
        }

        public void setRefillItems(boolean refillItems) {
            this.refillItems = refillItems;
            this.parent.markDirty();
        }
    }

    public static class BackpackItemHandler
    implements IItemHandler,
    INBTSerializable<CompoundNBT> {
        private List<SlotDefinition> definitionList = new ArrayList<SlotDefinition>();
        private int maxAmount;
        private BackpackDataManager dataManager;

        public BackpackItemHandler(BackpackDataManager manager) {
            for (int i = 0; i < 32; ++i) {
                this.definitionList.add(new SlotDefinition(this));
            }
            this.maxAmount = 2048;
            this.dataManager = manager;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT slots = new CompoundNBT();
            for (int i = 0; i < this.definitionList.size(); ++i) {
                slots.func_218657_a(i + "", (INBT)this.definitionList.get(i).serializeNBT());
            }
            CompoundNBT output = new CompoundNBT();
            output.func_218657_a("Slots", (INBT)slots);
            output.func_74768_a("MaxAmount", this.maxAmount);
            return output;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            CompoundNBT slots = nbt.func_74775_l("Slots");
            for (String s : slots.func_150296_c()) {
                this.definitionList.get(Integer.parseInt(s)).deserializeNBT(slots.func_74775_l(s));
            }
            this.maxAmount = nbt.func_74762_e("MaxAmount");
        }

        public int getSlots() {
            return this.definitionList.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.definitionList.get(slot).getStack(), (int)this.definitionList.get(slot).getAmount());
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                SlotDefinition definition = this.definitionList.get(slot);
                int inserted = Math.min(this.maxAmount - definition.getAmount(), stack.func_190916_E());
                if (definition.isVoidItems()) {
                    inserted = stack.func_190916_E();
                }
                if (!simulate) {
                    definition.setStack(stack);
                    definition.setAmount(Math.min(definition.getAmount() + inserted, this.maxAmount));
                    this.markDirty();
                }
                if (inserted == stack.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - inserted));
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.field_190927_a;
            }
            SlotDefinition definition = this.definitionList.get(slot);
            if (definition.getStack().func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (definition.getAmount() <= amount) {
                ItemStack out = definition.getStack().func_77946_l();
                int newAmount = definition.getAmount();
                if (!simulate) {
                    definition.setAmount(0);
                    this.markDirty();
                }
                out.func_190920_e(newAmount);
                return out;
            }
            if (!simulate) {
                definition.setAmount(definition.getAmount() - amount);
                this.markDirty();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)definition.getStack(), (int)amount);
        }

        public int getSlotLimit(int slot) {
            return this.maxAmount;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            SlotDefinition def = this.definitionList.get(slot);
            return def.getStack().func_190926_b() || def.getStack().func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)def.getStack(), (ItemStack)stack);
        }

        public void setMaxAmount(int maxAmount) {
            this.maxAmount = maxAmount;
            this.markDirty();
        }

        public void markDirty() {
            if (this.dataManager != null) {
                this.dataManager.func_76185_a();
            }
        }

        public SlotDefinition getSlotDefinition(int slot) {
            return this.definitionList.get(slot);
        }
    }
}

