/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.tracker.nearby;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerEngine;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListener;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.SectionPos;

public class NearbyEntityListenerMulti
implements NearbyEntityListener {
    private final List<NearbyEntityListener> listeners = new ArrayList<NearbyEntityListener>();
    @Nullable
    private EntityTrackerEngine trackingEngine;

    public void addListener(NearbyEntityListener listener) {
        SectionPos listenerLocation = null;
        if (this.trackingEngine != null) {
            listenerLocation = this.trackingEngine.removeListener(this);
        }
        this.listeners.add(listener);
        if (listenerLocation != null) {
            this.trackingEngine.addListener(listenerLocation.func_218149_a(), listenerLocation.func_218163_b(), listenerLocation.func_218148_c(), this);
        }
    }

    public void setTrackingEngine(@Nonnull EntityTrackerEngine trackingEngine) {
        if (this.trackingEngine != null && this.trackingEngine != trackingEngine) {
            throw new IllegalStateException("Adding to engine " + trackingEngine + " but is still in " + this.trackingEngine);
        }
        this.trackingEngine = trackingEngine;
    }

    public void clearTrackingEngine() {
        this.trackingEngine = null;
    }

    @Override
    public int getChunkRange() {
        int range = 0;
        for (NearbyEntityListener listener : this.listeners) {
            range = Math.max(range, listener.getChunkRange());
        }
        return range;
    }

    @Override
    public void onEntityEnteredRange(LivingEntity entity) {
        for (NearbyEntityListener listener : this.listeners) {
            listener.onEntityEnteredRange(entity);
        }
    }

    @Override
    public void onEntityLeftRange(LivingEntity entity) {
        for (NearbyEntityListener listener : this.listeners) {
            listener.onEntityLeftRange(entity);
        }
    }

    public String toString() {
        StringBuilder sublisteners = new StringBuilder();
        String comma = "";
        for (NearbyEntityListener listener : this.listeners) {
            sublisteners.append(comma).append(listener.toString());
            comma = ",";
        }
        return super.toString() + " with sublisteners: [" + sublisteners + "]";
    }
}

