/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes.hash;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import me.jellysquid.mods.lithium.mixin.shapes.side_shape_cache.BitSetVSAccess;
import me.jellysquid.mods.lithium.mixin.shapes.side_shape_cache.CroppedVoxelSetAccess;
import me.jellysquid.mods.lithium.mixin.shapes.side_shape_cache.VoxelSetAccess;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.PartSplitVoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;

public class VoxelSetHash
implements Hash.Strategy<VoxelShapePart> {
    public static final VoxelSetHash INSTANCE = new VoxelSetHash();

    public int hashCode(VoxelShapePart o) {
        VoxelSetAccess generalAccess = (VoxelSetAccess)o;
        int result = generalAccess.getXSize();
        result = 31 * result + generalAccess.getYSize();
        result = 31 * result + generalAccess.getZSize();
        if (o instanceof PartSplitVoxelShape) {
            CroppedVoxelSetAccess access = VoxelSetHash.access((PartSplitVoxelShape)o);
            result = 31 * result + access.getXMin();
            result = 31 * result + access.getYMin();
            result = 31 * result + access.getZMin();
            result = 31 * result + access.getXMax();
            result = 31 * result + access.getYMax();
            result = 31 * result + access.getZMax();
            result = 31 * result + this.hashCode(access.getParent());
            return result;
        }
        if (o instanceof BitSetVoxelShapePart) {
            BitSetVSAccess access = VoxelSetHash.access((BitSetVoxelShapePart)o);
            result = 31 * result + access.getXMin();
            result = 31 * result + access.getYMin();
            result = 31 * result + access.getZMin();
            result = 31 * result + access.getXMax();
            result = 31 * result + access.getYMax();
            result = 31 * result + access.getZMax();
            result = 31 * result + Objects.hashCode(access.getStorage());
            return result;
        }
        return 31 * result + Objects.hashCode(o);
    }

    public boolean equals(VoxelShapePart a, VoxelShapePart b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        VoxelSetAccess genAccessA = (VoxelSetAccess)a;
        VoxelSetAccess genAccessB = (VoxelSetAccess)b;
        if (genAccessA.getXSize() != genAccessB.getXSize() || genAccessA.getYSize() != genAccessB.getYSize() || genAccessA.getZSize() != genAccessB.getZSize()) {
            return false;
        }
        if (a instanceof PartSplitVoxelShape) {
            CroppedVoxelSetAccess accessA = VoxelSetHash.access((PartSplitVoxelShape)a);
            CroppedVoxelSetAccess accessB = VoxelSetHash.access((PartSplitVoxelShape)b);
            return accessA.getXMax() == accessB.getXMax() && accessA.getYMax() == accessB.getYMax() && accessA.getZMax() == accessB.getZMax() && accessA.getXMin() == accessB.getXMin() && accessA.getYMin() == accessB.getYMin() && accessA.getZMin() == accessB.getZMin() && this.equals(accessA.getParent(), accessB.getParent());
        }
        if (a instanceof BitSetVoxelShapePart) {
            BitSetVSAccess accessA = VoxelSetHash.access((BitSetVoxelShapePart)a);
            BitSetVSAccess accessB = VoxelSetHash.access((BitSetVoxelShapePart)b);
            return accessA.getXMax() == accessB.getXMax() && accessA.getYMax() == accessB.getYMax() && accessA.getZMax() == accessB.getZMax() && accessA.getXMin() == accessB.getXMin() && accessA.getYMin() == accessB.getYMin() && accessA.getZMin() == accessB.getZMin() && accessA.getStorage().equals(accessB.getStorage());
        }
        return a.equals(b);
    }

    private static CroppedVoxelSetAccess access(PartSplitVoxelShape part) {
        return (CroppedVoxelSetAccess)part;
    }

    private static BitSetVSAccess access(BitSetVoxelShapePart part) {
        return (BitSetVSAccess)part;
    }
}

