/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.collections;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class BlockEntityList
implements List<TileEntity> {
    private final ReferenceLinkedOpenHashSet<TileEntity> allBlockEntities;
    private final Long2ReferenceOpenHashMap<TileEntity> posMap;
    private final Long2ReferenceOpenHashMap<List<TileEntity>> posMapMulti;
    @Nullable
    private final Thread ownerThread;
    private final List<OffThreadOperation> offThreadModifications = new ArrayList<OffThreadOperation>();
    private volatile ConcurrentState hasOffThreadModifications = ConcurrentState.CLEAN;

    private BlockEntityList(boolean hasPositionLookup, boolean hasOwnerThread) {
        this.posMap = hasPositionLookup ? new Long2ReferenceOpenHashMap() : null;
        Long2ReferenceOpenHashMap long2ReferenceOpenHashMap = this.posMapMulti = hasPositionLookup ? new Long2ReferenceOpenHashMap() : null;
        if (this.posMap != null) {
            this.posMap.defaultReturnValue(null);
            this.posMapMulti.defaultReturnValue(null);
        }
        this.ownerThread = hasOwnerThread ? Thread.currentThread() : null;
        this.allBlockEntities = new ReferenceLinkedOpenHashSet();
    }

    public BlockEntityList(List<TileEntity> list, boolean hasPositionLookup, boolean hasOwnerThread) {
        this(hasPositionLookup, hasOwnerThread);
        this.addAll((Collection<? extends TileEntity>)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockEntityList(BlockEntityList original) {
        this(original.posMap != null, true);
        if (original.posMap != null) {
            this.posMap.putAll(original.posMap);
            this.posMapMulti.putAll(original.posMapMulti);
        }
        this.allBlockEntities.addAll(original.allBlockEntities);
        List<OffThreadOperation> list = original.offThreadModifications;
        synchronized (list) {
            this.hasOffThreadModifications = original.hasOffThreadModifications;
            this.offThreadModifications.addAll(original.offThreadModifications);
        }
    }

    @Override
    public int size() {
        if (!this.checkOffThreadModifications(true)) {
            return this.allBlockEntities.size();
        }
        return this.copyWithChanges().size();
    }

    @Override
    public boolean isEmpty() {
        if (!this.checkOffThreadModifications(true)) {
            return this.allBlockEntities.isEmpty();
        }
        return this.copyWithChanges().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!this.checkOffThreadModifications(true)) {
            return this.allBlockEntities.contains(o);
        }
        return this.copyWithChanges().contains(o);
    }

    @Override
    public Iterator<TileEntity> iterator() {
        if (!this.checkOffThreadModifications(true)) {
            return this.allBlockEntities.iterator();
        }
        return this.copyWithChanges().iterator();
    }

    @Override
    public Object[] toArray() {
        if (!this.checkOffThreadModifications(true)) {
            return this.allBlockEntities.toArray();
        }
        return this.copyWithChanges().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (!this.checkOffThreadModifications(true)) {
            return this.allBlockEntities.toArray((Object[])a);
        }
        return this.copyWithChanges().toArray(a);
    }

    @Override
    public boolean add(TileEntity blockEntity) {
        return this.addNoDoubleAdd(blockEntity, true);
    }

    private boolean addNoDoubleAdd(TileEntity blockEntity, boolean exceptionOnDoubleAdd) {
        long pos;
        TileEntity prev;
        if (this.currentlyOffThread()) {
            this.addOffThreadOperation(new OffThreadOperation(blockEntity, OperationType.ADD));
            return true;
        }
        this.checkOffThreadModifications(false);
        boolean added = this.allBlockEntities.add((Object)blockEntity);
        if (!added && exceptionOnDoubleAdd && !(blockEntity instanceof CommandBlockTileEntity)) {
            this.throwException(blockEntity);
        }
        if (added && this.posMap != null && (prev = (TileEntity)this.posMap.putIfAbsent(pos = BlockEntityList.getEntityPos(blockEntity), (Object)blockEntity)) != null) {
            List multiEntry = (List)this.posMapMulti.computeIfAbsent(pos, l -> new ArrayList());
            if (multiEntry.size() == 0) {
                multiEntry.add(prev);
            }
            multiEntry.add(blockEntity);
        }
        return added;
    }

    private void throwException(TileEntity blockEntity) {
        throw new IllegalStateException("RoadRunner BlockEntityList" + (this.posMap != null ? " with posMap" : "") + ": Adding the same BlockEntity object twice: " + blockEntity.func_189515_b(new CompoundNBT()));
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)o;
            if (this.currentlyOffThread()) {
                this.addOffThreadOperation(new OffThreadOperation(blockEntity, OperationType.REMOVE));
                return true;
            }
            this.checkOffThreadModifications(false);
            if (this.allBlockEntities.remove(o)) {
                if (this.posMap != null) {
                    long pos = BlockEntityList.getEntityPos(blockEntity);
                    List multiEntry = (List)this.posMapMulti.get(pos);
                    if (multiEntry != null) {
                        multiEntry.remove(blockEntity);
                        if (multiEntry.size() <= 1) {
                            this.posMapMulti.remove(pos);
                        }
                    }
                    if (multiEntry != null && multiEntry.size() > 0) {
                        this.posMap.put(pos, (Object)((TileEntity)multiEntry.get(0)));
                    } else {
                        this.posMap.remove(pos);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!this.checkOffThreadModifications(true)) {
            return this.allBlockEntities.containsAll(c);
        }
        return this.copyWithChanges().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends TileEntity> c) {
        for (TileEntity tileEntity : c) {
            this.add(tileEntity);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TileEntity> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object obj : c) {
            modified |= this.remove(obj);
        }
        return modified;
    }

    @Override
    public void clear() {
        if (this.currentlyOffThread()) {
            throw new UnsupportedOperationException();
        }
        this.checkOffThreadModifications(false);
        this.allBlockEntities.clear();
        if (this.posMap != null) {
            this.posMap.clear();
            this.posMapMulti.clear();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity set(int index, TileEntity element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, TileEntity element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<TileEntity> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<TileEntity> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TileEntity> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private static long getEntityPos(TileEntity e) {
        return e.func_174877_v().func_218275_a();
    }

    public boolean addIfAbsent(TileEntity blockEntity) {
        return this.addNoDoubleAdd(blockEntity, false);
    }

    public boolean hasPositionLookup() {
        return this.posMap != null;
    }

    public void markRemovedAndRemoveAllAtPosition(BlockPos blockPos) {
        if (this.currentlyOffThread()) {
            this.addOffThreadOperation(new OffThreadOperation(blockPos));
            return;
        }
        this.checkOffThreadModifications(false);
        long pos = blockPos.func_218275_a();
        TileEntity blockEntity = (TileEntity)this.posMap.remove(pos);
        if (blockEntity != null) {
            List multiEntry = (List)this.posMapMulti.remove(pos);
            if (multiEntry != null) {
                for (TileEntity blockEntity1 : multiEntry) {
                    blockEntity1.func_145843_s();
                    this.allBlockEntities.remove((Object)blockEntity1);
                }
            } else {
                blockEntity.func_145843_s();
                this.allBlockEntities.remove((Object)blockEntity);
            }
        }
    }

    public TileEntity getFirstNonRemovedBlockEntityAtPosition(long pos) {
        if (this.checkOffThreadModifications(true)) {
            return this.copyWithChanges().getFirstNonRemovedBlockEntityAtPosition(pos);
        }
        if (this.isEmpty()) {
            return null;
        }
        TileEntity blockEntity = (TileEntity)this.posMap.get(pos);
        if (blockEntity == null || !blockEntity.func_145837_r()) {
            return blockEntity;
        }
        List multiEntry = (List)this.posMapMulti.get(pos);
        if (multiEntry != null) {
            for (TileEntity blockEntity1 : multiEntry) {
                if (blockEntity1.func_145837_r()) continue;
                return blockEntity1;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOffThreadModifications(boolean isReadOnly) {
        if (this.ownerThread == null) {
            return false;
        }
        if (this.ownerThread != Thread.currentThread()) {
            return this.hasOffThreadModifications != ConcurrentState.CLEAN;
        }
        if (isReadOnly || this.hasOffThreadModifications != ConcurrentState.DIRTY) {
            return false;
        }
        List<OffThreadOperation> list = this.offThreadModifications;
        synchronized (list) {
            this.hasOffThreadModifications = ConcurrentState.CLEANING;
            for (OffThreadOperation op : this.offThreadModifications) {
                switch (op.type) {
                    case ADD: {
                        this.addIfAbsent((TileEntity)Preconditions.checkNotNull((Object)op.blockEntity));
                        break;
                    }
                    case REMOVE: {
                        this.remove(Preconditions.checkNotNull((Object)op.blockEntity));
                        break;
                    }
                    case REMOVE_AT: {
                        this.markRemovedAndRemoveAllAtPosition((BlockPos)Preconditions.checkNotNull((Object)op.pos));
                    }
                }
            }
            this.hasOffThreadModifications = ConcurrentState.CLEAN;
            this.offThreadModifications.clear();
        }
        return false;
    }

    private boolean currentlyOffThread() {
        return this.ownerThread != null && this.ownerThread != Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOffThreadOperation(OffThreadOperation op) {
        List<OffThreadOperation> list = this.offThreadModifications;
        synchronized (list) {
            this.offThreadModifications.add(op);
            this.hasOffThreadModifications = ConcurrentState.DIRTY;
        }
    }

    private BlockEntityList copyWithChanges() {
        BlockEntityList result = new BlockEntityList(this);
        Preconditions.checkState((!result.checkOffThreadModifications(false) ? 1 : 0) != 0);
        return result;
    }

    private static enum ConcurrentState {
        CLEAN,
        DIRTY,
        CLEANING;

    }

    private static class OffThreadOperation {
        private final TileEntity blockEntity;
        private final BlockPos pos;
        private final OperationType type;

        private OffThreadOperation(TileEntity blockEntity, OperationType type) {
            this.blockEntity = blockEntity;
            this.pos = null;
            this.type = type;
        }

        private OffThreadOperation(BlockPos at) {
            this.blockEntity = null;
            this.pos = at;
            this.type = OperationType.REMOVE_AT;
        }
    }

    private static enum OperationType {
        ADD,
        REMOVE,
        REMOVE_AT;

    }
}

