/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.collections;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class RepeatedlyAccessedMap<K, V> {
    private final Map<K, V> storage;
    private final Hash.Strategy<K> hash;
    private K lastKey;
    private V lastValue;

    public RepeatedlyAccessedMap(Hash.Strategy<K> hash) {
        this.storage = new Object2ObjectOpenCustomHashMap(hash);
        this.hash = hash;
    }

    public V get(K key) {
        Objects.requireNonNull(key);
        if (this.hash.equals(this.lastKey, key)) {
            return this.lastValue;
        }
        V result = this.storage.get(key);
        this.recordAccess(key, result);
        return result;
    }

    public V computeIfAbsent(K key, Function<K, V> makeNew) {
        Objects.requireNonNull(key);
        if (this.lastValue != null && this.hash.equals(this.lastKey, key)) {
            return this.lastValue;
        }
        V result = this.storage.computeIfAbsent(key, makeNew);
        this.recordAccess(key, result);
        return result;
    }

    private void recordAccess(K key, V value) {
        this.lastKey = key;
        this.lastValue = value;
    }
}

