/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.block_entity_ticking.collections;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import me.jellysquid.mods.lithium.common.util.collections.BlockEntityList;
import net.minecraft.block.BlockState;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={World.class})
public abstract class WorldMixin
implements IWorld {
    @Shadow
    @Final
    public boolean field_72995_K;
    @Mutable
    @Shadow
    @Final
    public List<TileEntity> field_147482_g;
    @Shadow
    @Final
    public List<TileEntity> field_175730_i;
    @Mutable
    @Shadow
    @Final
    protected List<TileEntity> field_147484_a;
    @Shadow
    @Final
    private Supplier<IProfiler> field_72984_F;
    private BlockEntityList blockEntities$lithium;
    private BlockEntityList pendingBlockEntities$lithium;

    @Shadow
    public abstract boolean func_201670_d();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reinit(ISpawnWorldInfo properties, RegistryKey<World> registryKey, DimensionType dimensionType, Supplier<IProfiler> supplier, boolean bl, boolean bl2, long l, CallbackInfo ci) {
        this.field_147482_g = this.blockEntities$lithium = new BlockEntityList(this.field_147482_g, false, this.field_72995_K);
        this.field_147484_a = this.pendingBlockEntities$lithium = new BlockEntityList(this.field_147484_a, true, this.field_72995_K);
    }

    @Overwrite
    public TileEntity func_189508_F(BlockPos pos) {
        return this.pendingBlockEntities$lithium.getFirstNonRemovedBlockEntityAtPosition(pos.func_218275_a());
    }

    @Redirect(method={"tickBlockEntities"}, at=@At(value="FIELD", target="Lnet/minecraft/world/World;pendingBlockEntities:Ljava/util/List;", ordinal=0))
    private List<?> nullifyPendingBlockEntityListDuringTick(World world) {
        return Collections.emptyList();
    }

    @Inject(method={"tickBlockEntities"}, at={@At(value="RETURN")})
    private void postBlockEntityTick(CallbackInfo ci) {
        IProfiler profiler = this.field_72984_F.get();
        profiler.func_76320_a("pendingBlockEntities$lithium");
        this.blockEntities$lithium.checkOffThreadModifications(false);
        this.pendingBlockEntities$lithium.checkOffThreadModifications(false);
        for (TileEntity entity : this.field_147484_a) {
            if (entity.func_145837_r() || !this.blockEntities$lithium.addIfAbsent(entity)) continue;
            if (entity instanceof ITickableTileEntity) {
                this.field_175730_i.add(entity);
            }
            BlockPos pos = entity.func_174877_v();
            World thisWorld = (World)this;
            if (entity.func_145831_w() != thisWorld) {
                entity.func_226984_a_(thisWorld, pos);
            }
            entity.onLoad();
            IChunk chunk = this.func_217353_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, ChunkStatus.field_222617_m, this.field_72995_K);
            if (chunk == null) continue;
            BlockState state = chunk.func_180495_p(pos);
            chunk.func_177426_a(pos, entity);
            this.func_184138_a(pos, state, state, 3);
        }
        this.field_147484_a.clear();
        profiler.func_76319_b();
    }

    @Redirect(method={"setBlockEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/BlockEntity;setLocation(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"))
    private void setLocationAndRemoveAllAtPosition(TileEntity blockEntity, World world, BlockPos pos) {
        blockEntity.func_226984_a_(world, pos);
        this.pendingBlockEntities$lithium.markRemovedAndRemoveAllAtPosition(pos);
    }

    @Redirect(method={"setBlockEntity"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;"))
    private <E> Iterator<E> nullifyBlockEntityScanDuringSetBlockEntity(List<E> list) {
        return Collections.emptyIterator();
    }

    @Shadow
    public abstract void func_184138_a(BlockPos var1, BlockState var2, BlockState var3, int var4);
}

