/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.chunk_access;

import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.jellysquid.mods.lithium.common.world.chunk.ChunkHolderExtended;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkProvider.class})
public abstract class ServerChunkManagerMixin {
    @Shadow
    @Final
    private ServerChunkProvider.ChunkExecutor field_217243_i;
    @Shadow
    @Final
    private TicketManager field_217240_d;
    @Shadow
    @Final
    public ChunkManager field_217237_a;
    @Shadow
    @Final
    private Thread field_217241_g;
    private long time;
    private final long[] cacheKeys = new long[4];
    private final IChunk[] cacheChunks = new IChunk[4];

    @Shadow
    protected abstract ChunkHolder func_217213_a(long var1);

    @Shadow
    protected abstract boolean func_217235_l();

    @Shadow
    protected abstract boolean func_217224_a(ChunkHolder var1, int var2);

    @Inject(method={"tick()Z"}, at={@At(value="HEAD")})
    private void preTick(CallbackInfoReturnable<Boolean> cir) {
        ++this.time;
    }

    @Overwrite
    public IChunk func_212849_a_(int x, int z, ChunkStatus status, boolean create) {
        if (Thread.currentThread() != this.field_217241_g) {
            return this.getChunkOffThread(x, z, status, create);
        }
        long[] cacheKeys = this.cacheKeys;
        long key = ServerChunkManagerMixin.createCacheKey(x, z, status);
        for (int i = 0; i < 4; ++i) {
            IChunk chunk;
            if (key != cacheKeys[i] || (chunk = this.cacheChunks[i]) == null && create) continue;
            return chunk;
        }
        IChunk chunk = this.getChunkBlocking(x, z, status, create);
        if (chunk != null) {
            this.addToCache(key, chunk);
        } else if (create) {
            throw new IllegalStateException("Chunk not there when requested");
        }
        return chunk;
    }

    private IChunk getChunkOffThread(int x, int z, ChunkStatus status, boolean create) {
        return CompletableFuture.supplyAsync(() -> this.func_212849_a_(x, z, status, create), (Executor)this.field_217243_i).join();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IChunk getChunkBlocking(int x, int z, ChunkStatus status, boolean create) {
        long key = ChunkPos.func_77272_a((int)x, (int)z);
        int level = 33 + ChunkStatus.func_222599_a((ChunkStatus)status);
        ChunkHolder holder = this.func_217213_a(key);
        if (this.func_217224_a(holder, level)) {
            if (!create) return null;
            this.createChunkLoadTicket(x, z, level);
            this.func_217235_l();
            holder = this.func_217213_a(key);
            if (this.func_217224_a(holder, level)) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("No chunk holder after ticket has been added"));
            }
        } else if (((ChunkHolderExtended)holder).updateLastAccessTime(this.time)) {
            this.createChunkLoadTicket(x, z, level);
        }
        CompletableFuture loadFuture = null;
        CompletableFuture statusFuture = ((ChunkHolderExtended)holder).getFutureByStatus(status.func_222584_c());
        if (statusFuture != null) {
            Either immediate = statusFuture.getNow(null);
            if (immediate != null) {
                Optional chunk = immediate.left();
                if (chunk.isPresent()) {
                    return (IChunk)chunk.get();
                }
            } else {
                loadFuture = statusFuture;
            }
        }
        if (loadFuture == null) {
            if (ChunkHolder.func_219278_b((int)holder.func_219299_i()).func_209003_a(status)) {
                CompletableFuture mergedFuture = this.field_217237_a.func_219244_a(holder, status);
                holder.func_219284_a(mergedFuture);
                ((ChunkHolderExtended)holder).setFutureForStatus(status.func_222584_c(), mergedFuture);
                loadFuture = mergedFuture;
            } else {
                if (statusFuture == null) {
                    return null;
                }
                loadFuture = statusFuture;
            }
        }
        if (loadFuture.isDone()) return ((Either)loadFuture.join()).left().orElse(null);
        this.field_217243_i.func_213161_c(loadFuture::isDone);
        return ((Either)loadFuture.join()).left().orElse(null);
    }

    private void createChunkLoadTicket(int x, int z, int level) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        this.field_217240_d.func_219356_a(TicketType.field_219494_g, chunkPos, level, (Object)chunkPos);
    }

    private static long createCacheKey(int chunkX, int chunkZ, ChunkStatus status) {
        return (long)chunkX & 0xFFFFFFFL | ((long)chunkZ & 0xFFFFFFFL) << 28 | (long)status.func_222584_c() << 56;
    }

    private void addToCache(long key, IChunk chunk) {
        for (int i = 3; i > 0; --i) {
            this.cacheKeys[i] = this.cacheKeys[i - 1];
            this.cacheChunks[i] = this.cacheChunks[i - 1];
        }
        this.cacheKeys[0] = key;
        this.cacheChunks[0] = chunk;
    }

    @Inject(method={"initChunkCaches"}, at={@At(value="HEAD")})
    private void onCachesCleared(CallbackInfo ci) {
        Arrays.fill(this.cacheKeys, Long.MAX_VALUE);
        Arrays.fill(this.cacheChunks, null);
    }
}

