/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.coolant;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.FluidsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.SourceTag;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class FluidMappingsRegistry {
    private static final Map<ITag.INamedTag<Fluid>, IMapping<ITag.INamedTag<Fluid>, Coolant>> s_fluidToCoolant = new Object2ObjectArrayMap(2);
    private static final Map<ITag.INamedTag<Fluid>, IMapping<ITag.INamedTag<Fluid>, Vapor>> s_fluidToVapor = new Object2ObjectArrayMap(2);
    private static final Map<Coolant, List<IMapping<Coolant, ITag.INamedTag<Fluid>>>> s_coolantToFluid = new Object2ObjectArrayMap(2);
    private static final Map<Vapor, List<IMapping<Vapor, ITag.INamedTag<Fluid>>>> s_vaporToFluid = new Object2ObjectArrayMap(2);
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/FluidMappingsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean hasCoolantFrom(FluidStack stack) {
        return FluidMappingsRegistry.getCoolantFrom(stack).isPresent();
    }

    public static boolean hasCoolantFrom(Fluid stack) {
        return FluidMappingsRegistry.getCoolantFrom(stack).isPresent();
    }

    public static boolean hasVaporFrom(FluidStack stack) {
        return FluidMappingsRegistry.getVaporFrom(stack).isPresent();
    }

    public static boolean hasVaporFrom(Fluid stack) {
        return FluidMappingsRegistry.getVaporFrom(stack).isPresent();
    }

    public static Optional<IMapping<ITag.INamedTag<Fluid>, Coolant>> getCoolantFrom(FluidStack stack) {
        return FluidMappingsRegistry.getFrom(s_fluidToCoolant, stack);
    }

    public static Optional<IMapping<ITag.INamedTag<Fluid>, Coolant>> getCoolantFrom(Fluid fluid) {
        return FluidMappingsRegistry.getFrom(s_fluidToCoolant, fluid);
    }

    public static Optional<IMapping<ITag.INamedTag<Fluid>, Vapor>> getVaporFrom(FluidStack stack) {
        return FluidMappingsRegistry.getFrom(s_fluidToVapor, stack);
    }

    public static Optional<IMapping<ITag.INamedTag<Fluid>, Vapor>> getVaporFrom(Fluid fluid) {
        return FluidMappingsRegistry.getFrom(s_fluidToVapor, fluid);
    }

    public static Optional<List<IMapping<Coolant, ITag.INamedTag<Fluid>>>> getFluidFrom(Coolant coolant) {
        return Optional.ofNullable(s_coolantToFluid.get(coolant));
    }

    public static Optional<List<IMapping<Vapor, ITag.INamedTag<Fluid>>>> getFluidFrom(Vapor vapor) {
        return Optional.ofNullable(s_vaporToFluid.get(vapor));
    }

    public static void registerCoolantMapping(String name, int quantity, ITag.INamedTag<Fluid> source) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-mapping-register", () -> {
            Optional<Coolant> coolant;
            int qty = quantity;
            if (qty < 0) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Using default quantity for Coolant {} instead of the provided, invalid, one: {}", (Object)name, (Object)qty);
                qty = 1;
            }
            if ((coolant = FluidsRegistry.getCoolant(name)).isPresent()) {
                IMapping<ITag.INamedTag, Coolant> mapping = IMapping.of(source, 1, coolant.get(), qty);
                s_fluidToCoolant.put((ITag.INamedTag<Fluid>)mapping.getSource(), mapping);
                s_coolantToFluid.computeIfAbsent(mapping.getProduct(), k -> Lists.newArrayList()).add(mapping.getReverse());
            } else {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source Coolant: {}", (Object)name);
            }
        });
    }

    public static void removeCoolantMapping(ITag.INamedTag<Fluid> sourceFluidTag) {
        FluidMappingsRegistry.removeSourceMapping(sourceFluidTag.func_230234_a_(), s_fluidToCoolant, s_coolantToFluid);
    }

    public static void removeCoolantMapping(String sourceFluidTagId) {
        FluidMappingsRegistry.removeSourceMapping(new ResourceLocation(sourceFluidTagId), s_fluidToCoolant, s_coolantToFluid);
    }

    public static void registerVaporMapping(String name, int quantity, ITag.INamedTag<Fluid> source) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-mapping-register", () -> {
            Optional<Vapor> entry;
            int qty = quantity;
            if (qty < 0) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Using default quantity for Vapor {} instead of the provided, invalid, one: {}", (Object)name, (Object)qty);
                qty = 1;
            }
            if ((entry = FluidsRegistry.getVapor(name)).isPresent()) {
                IMapping<ITag.INamedTag, Vapor> mapping = IMapping.of(source, 1, entry.get(), qty);
                s_fluidToVapor.put((ITag.INamedTag<Fluid>)mapping.getSource(), mapping);
                s_vaporToFluid.computeIfAbsent(mapping.getProduct(), k -> Lists.newArrayList()).add(mapping.getReverse());
            } else {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source Vapor: {}", (Object)name);
            }
        });
    }

    public static void removeVaporMapping(ITag.INamedTag<Fluid> sourceFluidTag) {
        FluidMappingsRegistry.removeSourceMapping(sourceFluidTag.func_230234_a_(), s_fluidToVapor, s_vaporToFluid);
    }

    public static void removeVaporMapping(String sourceFluidTagId) {
        FluidMappingsRegistry.removeSourceMapping(new ResourceLocation(sourceFluidTagId), s_fluidToVapor, s_vaporToFluid);
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        FluidMappingsRegistry.processWrapper("Coolants", wrapper.CoolantSources, s_fluidToCoolant, s_coolantToFluid, FluidMappingsRegistry::removeCoolantMapping, source -> FluidMappingsRegistry.registerCoolantMapping(source.ProductName, source.ProductQuantity, (ITag.INamedTag<Fluid>)TagsHelper.FLUIDS.createOptionalTag(source.SourceTagId)));
        FluidMappingsRegistry.processWrapper("Vapors", wrapper.VaporSources, s_fluidToVapor, s_vaporToFluid, FluidMappingsRegistry::removeVaporMapping, source -> FluidMappingsRegistry.registerVaporMapping(source.ProductName, source.ProductQuantity, (ITag.INamedTag<Fluid>)TagsHelper.FLUIDS.createOptionalTag(source.SourceTagId)));
    }

    private FluidMappingsRegistry() {
    }

    private static <T> Optional<IMapping<ITag.INamedTag<Fluid>, T>> getFrom(Map<ITag.INamedTag<Fluid>, IMapping<ITag.INamedTag<Fluid>, T>> map, FluidStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        return FluidMappingsRegistry.getFrom(map, stack.getFluid());
    }

    private static <T> Optional<IMapping<ITag.INamedTag<Fluid>, T>> getFrom(Map<ITag.INamedTag<Fluid>, IMapping<ITag.INamedTag<Fluid>, T>> map, Fluid fluid) {
        return map.entrySet().stream().filter(entry -> ((ITag.INamedTag)entry.getKey()).func_230235_a_((Object)fluid)).map(Map.Entry::getValue).findAny();
    }

    private static <X> void removeSourceMapping(ResourceLocation sourceFluidTagId, Map<ITag.INamedTag<Fluid>, IMapping<ITag.INamedTag<Fluid>, X>> fluidToX, Map<X, List<IMapping<X, ITag.INamedTag<Fluid>>>> xToFluid) {
        Preconditions.checkNotNull((Object)sourceFluidTagId);
        Preconditions.checkNotNull(fluidToX);
        Preconditions.checkNotNull(xToFluid);
        InternalDispatcher.dispatch("fluid-mapping-remove", () -> {
            Optional<ITag.INamedTag> fluidTag = fluidToX.keySet().stream().filter(tag -> tag.func_230234_a_().equals((Object)sourceFluidTagId)).findFirst();
            fluidTag.ifPresent(tag -> {
                IMapping removedMapping = (IMapping)fluidToX.remove(tag);
                if (null != removedMapping) {
                    xToFluid.getOrDefault(removedMapping.getProduct(), Collections.emptyList()).removeIf(xToTagMapping -> ((ITag.INamedTag)xToTagMapping.getProduct()).equals(tag));
                    xToFluid.entrySet().stream().filter(entry -> ((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(xToFluid::remove);
                }
            });
        });
    }

    private static <X> void processWrapper(String objectName, AddRemoveSection<SourceTag> wrapperSection, Map<ITag.INamedTag<Fluid>, IMapping<ITag.INamedTag<Fluid>, X>> fluidToX, Map<X, List<IMapping<X, ITag.INamedTag<Fluid>>>> xToFluid, Consumer<String> removeAction, Consumer<SourceTag> addAction) {
        if (wrapperSection.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing {} sources", (Object)objectName);
            fluidToX.clear();
            xToFluid.clear();
        } else {
            Arrays.stream(wrapperSection.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(removeAction);
        }
        Arrays.stream(wrapperSection.Add).filter(Objects::nonNull).forEach(addAction);
    }
}

