/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent;

import it.zerono.mods.extremereactors.api.coolant.FluidMappingsRegistry;
import it.zerono.mods.extremereactors.api.coolant.FluidsRegistry;
import it.zerono.mods.extremereactors.api.coolant.TransitionsRegistry;
import it.zerono.mods.extremereactors.api.reactor.Moderator;
import it.zerono.mods.extremereactors.api.reactor.ModeratorsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactionsRegistry;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Reactants;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

final class ReactorGameData {
    ReactorGameData() {
    }

    static void register() {
        ReactorGameData.registerReactants();
        ReactorGameData.registerReactantMappings();
        ReactorGameData.registerReactions();
        ReactorGameData.registerModerators();
        ReactorGameData.registerCoolantsAndVapors();
    }

    private static void registerReactants() {
        ReactorGameData.registerReactant(Reactants.Yellorium);
        ReactorGameData.registerReactantFuel(Reactants.Blutonium, 2.23f, 0.6f, 2.0f, 0.0137f, 6.0E-4f);
        ReactorGameData.registerReactantFuel(Reactants.Verderium, 3.74f, 0.8741f, 2.0049f, 0.0312f, 0.0081f);
        ReactorGameData.registerReactant(Reactants.Cyanite);
        ReactorGameData.registerReactant(Reactants.Magentite);
        ReactorGameData.registerReactant(Reactants.Rossinite);
    }

    private static void registerReactantMappings() {
        ReactorGameData.registerIngotReactantMapping(Reactants.Yellorium, ContentTags.Items.INGOTS_YELLORIUM, 1);
        ReactorGameData.registerIngotReactantMapping(Reactants.Yellorium, "forge:ingots/uranium", 1);
        ReactorGameData.registerIngotReactantMapping(Reactants.Yellorium, ContentTags.Items.BLOCKS_YELLORIUM, 9);
        ReactorGameData.registerIngotReactantMapping(Reactants.Yellorium, "forge:storage_blocks/uranium", 9);
        ReactorGameData.registerIngotReactantMapping(Reactants.Blutonium, ContentTags.Items.INGOTS_BLUTONIUM, 1);
        ReactorGameData.registerIngotReactantMapping(Reactants.Blutonium, "forge:ingots/plutonium", 1);
        ReactorGameData.registerIngotReactantMapping(Reactants.Blutonium, ContentTags.Items.BLOCKS_BLUTONIUM, 9);
        ReactorGameData.registerIngotReactantMapping(Reactants.Blutonium, "forge:storage_blocks/plutonium", 9);
        ReactorGameData.registerIngotReactantMapping(Reactants.Cyanite, ContentTags.Items.INGOTS_CYANITE, 1);
        ReactorGameData.registerIngotReactantMapping(Reactants.Cyanite, ContentTags.Items.BLOCKS_CYANITE, 9);
        ReactorGameData.registerIngotReactantMapping(Reactants.Magentite, ContentTags.Items.INGOTS_MAGENTITE, 1);
        ReactorGameData.registerIngotReactantMapping(Reactants.Magentite, ContentTags.Items.BLOCKS_MAGENTITE, 9);
        ReactorGameData.registerFluidReactantMapping(Reactants.Yellorium, ContentTags.Fluids.YELLORIUM);
        ReactorGameData.registerFluidReactantMapping(Reactants.Cyanite, ContentTags.Fluids.CYANITE);
        ReactorGameData.registerFluidReactantMapping(Reactants.Blutonium, ContentTags.Fluids.BLUTONIUM);
        ReactorGameData.registerFluidReactantMapping(Reactants.Magentite, ContentTags.Fluids.MAGENTITE);
        ReactorGameData.registerFluidReactantMapping(Reactants.Verderium, ContentTags.Fluids.VERDERIUM);
        ReactorGameData.registerFluidReactantMapping(Reactants.Rossinite, ContentTags.Fluids.ROSSINITE);
    }

    private static void registerReactions() {
        ReactionsRegistry.register(Reactants.Yellorium.getReactantName(), Reactants.Cyanite.getReactantName(), 1.05f, 0.01f);
        ReactionsRegistry.register(Reactants.Blutonium.getReactantName(), Reactants.Magentite.getReactantName(), 1.0871f, 0.051f);
        ReactionsRegistry.register(Reactants.Verderium.getReactantName(), Reactants.Rossinite.getReactantName(), 1.0984f, 0.0743f);
    }

    private static void registerModerators() {
        ModeratorsRegistry.registerSolid("forge:storage_block/apatite", 0.48f, 0.73f, 1.3f, 0.15f);
        ModeratorsRegistry.registerSolid("forge:storage_block/cinnabar", 0.48f, 0.75f, 1.32f, 0.15f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/iron", 0.5f, 0.75f, 1.4f, 0.6f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/manasteel", 0.6f, 0.75f, 1.5f, 0.6f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/elementium", 0.61f, 0.77f, 1.52f, 2.5f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/nickel", 0.51f, 0.77f, 1.4f, 0.6f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/gold", 0.52f, 0.8f, 1.45f, 2.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/diamond", 0.55f, 0.85f, 1.5f, 3.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/netherite", 0.55f, 0.95f, 1.65f, 3.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/terrasteel", 0.57f, 0.87f, 1.52f, 3.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/emerald", 0.55f, 0.85f, 1.5f, 2.5f);
        ModeratorsRegistry.registerSolid("forge:glass/colorless", 0.2f, 0.25f, 1.1f, 0.3f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/copper", 0.5f, 0.75f, 1.4f, 1.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/brass", 0.52f, 0.78f, 1.42f, 1.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/osmium", 0.51f, 0.77f, 1.41f, 1.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/refined_obsidian", 0.53f, 0.79f, 1.42f, 1.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/refined_glowstone", 0.54f, 0.79f, 1.44f, 2.5f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/bronze", 0.51f, 0.77f, 1.41f, 1.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/zinc", 0.51f, 0.77f, 1.41f, 1.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/aluminum", 0.5f, 0.78f, 1.42f, 0.6f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/steel", 0.5f, 0.78f, 1.42f, 0.6f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/invar", 0.5f, 0.79f, 1.43f, 0.6f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/tin", 0.5f, 0.73f, 1.38f, 1.5f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/silver", 0.51f, 0.79f, 1.43f, 1.5f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/signalum", 0.51f, 0.75f, 1.42f, 1.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/lumium", 0.51f, 0.79f, 1.45f, 1.5f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/lead", 0.75f, 0.75f, 1.75f, 1.5f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/electrum", 0.53f, 0.82f, 1.47f, 2.2f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/platinum", 0.57f, 0.86f, 1.58f, 2.5f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/enderium", 0.6f, 0.88f, 1.6f, 3.0f);
        ModeratorsRegistry.registerSolid("forge:storage_blocks/graphite", 0.1f, 0.5f, 2.0f, 2.0f);
        ModeratorsRegistry.registerSolid("minecraft:ice", 0.33f, 0.33f, 1.15f, 0.1f);
        ModeratorsRegistry.registerSolid("bigreactors:dry_ice", 0.42f, 0.52f, 1.32f, 0.1f);
        ModeratorsRegistry.registerFluid("bigreactors:cryomisi", 0.75f, 0.55f, 1.6f, 2.5f);
        ModeratorsRegistry.registerFluid("bigreactors:cryomisi_flowing", 0.68f, 0.49f, 1.4f, 2.5f);
        ModeratorsRegistry.registerFluid("bigreactors:tangerium", 0.9f, 0.75f, 2.0f, 2.0f);
        ModeratorsRegistry.registerFluid("bigreactors:tangerium_flowing", 0.84f, 0.69f, 1.7f, 2.0f);
        ModeratorsRegistry.registerFluid("bigreactors:redfrigium", 0.66f, 0.95f, 6.0f, 3.0f);
        ModeratorsRegistry.registerFluid("bigreactors:redfrigium_flowing", 0.57f, 0.86f, 5.0f, 3.0f);
        ModeratorsRegistry.registerFluid("minecraft:water", Moderator.WATER.getAbsorption(), Moderator.WATER.getHeatEfficiency(), Moderator.WATER.getModeration(), Moderator.WATER.getHeatConductivity());
        ModeratorsRegistry.registerFluid("minecraft:flowing_water", Moderator.WATER.getAbsorption(), Moderator.WATER.getHeatEfficiency(), Moderator.WATER.getModeration(), Moderator.WATER.getHeatConductivity());
        ModeratorsRegistry.registerFluid("astralsorcery:liquid_starlight", 0.92f, 0.8f, 2.0f, 3.0f);
        ModeratorsRegistry.registerFluid("astralsorcery:liquid_starlight_flowing", 0.8f, 0.85f, 2.0f, 3.0f);
        ModeratorsRegistry.registerFluid("bloodmagic:life_essence_fluid", 0.8f, 0.55f, 1.75f, 2.5f);
        ModeratorsRegistry.registerFluid("bloodmagic:life_essence_fluid_flowing", 0.7f, 0.55f, 1.75f, 2.5f);
        ModeratorsRegistry.registerFluid("mekanism:hydrofluoric_acid", 0.68f, 0.45f, 1.4f, 2.5f);
        ModeratorsRegistry.registerFluid("mekanism:flowing_hydrofluoric_acid", 0.6f, 0.45f, 1.4f, 2.5f);
        ModeratorsRegistry.registerFluid("mekanism:sodium", 0.28f, 0.6f, 1.7f, 1.0f);
        ModeratorsRegistry.registerFluid("mekanism:flowing_sodium", 0.23f, 0.6f, 1.7f, 1.0f);
        ModeratorsRegistry.registerFluid("mekanism:hydrogen_chloride", 0.38f, 0.65f, 1.7f, 1.0f);
        ModeratorsRegistry.registerFluid("mekanism:flowing_hydrogen_chloride", 0.31f, 0.65f, 1.7f, 1.0f);
        ModeratorsRegistry.registerFluid("mekanism:ethene", 0.45f, 0.65f, 1.9f, 1.5f);
        ModeratorsRegistry.registerFluid("mekanism:flowing_ethene", 0.37f, 0.65f, 1.9f, 1.5f);
    }

    private static void registerCoolantsAndVapors() {
        FluidsRegistry.registerCoolant("water", 100.0f, 4.0f, "fluid.bigreactors.water");
        FluidMappingsRegistry.registerCoolantMapping("water", 1, ContentTags.Fluids.WATER);
        FluidsRegistry.registerVapor("steam", 10.0f, "fluid.bigreactors.steam");
        FluidMappingsRegistry.registerVaporMapping("steam", 1, ContentTags.Fluids.STEAM);
        TransitionsRegistry.register("water", "steam");
    }

    private static void registerReactant(Reactants reactant) {
        ReactantsRegistry.register(reactant.getReactantName(), reactant.getType(), reactant.getColour(), reactant.getLangKey());
    }

    private static void registerReactantFuel(Reactants reactant, float moderationFactor, float absorptionCoefficient, float hardnessDivisor, float fissionEventsPerFuelUnit, float fuelUnitsPerFissionEvent) {
        ReactantsRegistry.registerFuel(reactant.getReactantName(), reactant.getColour(), moderationFactor, absorptionCoefficient, hardnessDivisor, fissionEventsPerFuelUnit, fuelUnitsPerFissionEvent, reactant.getLangKey());
    }

    private static void registerIngotReactantMapping(Reactants reactant, ITag.INamedTag<Item> tag, int ingotsCount) {
        ReactorGameData.registerIngotReactantMapping(reactant, tag.func_230234_a_(), ingotsCount);
    }

    private static void registerIngotReactantMapping(Reactants reactant, String itemTagId, int ingotsCount) {
        ReactorGameData.registerIngotReactantMapping(reactant, new ResourceLocation(itemTagId), ingotsCount);
    }

    private static void registerIngotReactantMapping(Reactants reactant, ResourceLocation itemTagId, int ingotsCount) {
        ReactantMappingsRegistry.registerSolid(reactant.getReactantName(), ingotsCount * 1000, itemTagId);
    }

    private static void registerFluidReactantMapping(Reactants reactant, ITag.INamedTag<Fluid> tag) {
        ReactantMappingsRegistry.registerFluid(reactant.getReactantName(), tag.func_230234_a_());
    }
}

