/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.fluid;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Reactants;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class ReactantFluid
extends ForgeFlowingFluid {
    private final NonNullConsumer<LivingEntity> _effectProvider;

    protected ReactantFluid(Supplier<Source> source, Supplier<Flowing> flowing, Supplier<Block> block, Supplier<? extends Item> bucket, int colour, NonNullConsumer<LivingEntity> effectProvider) {
        super(new ForgeFlowingFluid.Properties(source, flowing, FluidAttributes.builder((ResourceLocation)CommonConstants.FLUID_TEXTURE_SOURCE_WATER, (ResourceLocation)CommonConstants.FLUID_TEXTURE_FLOWING_WATER).overlay(CommonConstants.FLUID_TEXTURE_OVERLAY_WATER).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K).density(2000).luminosity(5).color(0xFF000000 | colour)).bucket(bucket).block(block));
        this._effectProvider = effectProvider;
    }

    protected void applyEffect(LivingEntity entity) {
        this._effectProvider.accept((Object)entity);
    }

    public static class Block
    extends FlowingFluidBlock {
        final Supplier<? extends ReactantFluid> _fluidSupplier;

        public Block(Supplier<? extends ReactantFluid> fluid) {
            super(fluid, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_235838_a_(state -> 6).func_200943_b(100.0f).func_222380_e());
            this._fluidSupplier = fluid;
        }

        public void func_196262_a(BlockState state, World world, BlockPos position, Entity entity) {
            super.func_196262_a(state, world, position, entity);
            if (entity instanceof LivingEntity && (Integer)state.func_177229_b((Property)field_176367_b) > 0) {
                this._fluidSupplier.get().applyEffect((LivingEntity)entity);
            }
        }
    }

    public static class Source
    extends ReactantFluid {
        public Source(Reactants reactant, Supplier<Source> sourceFluid, Supplier<Flowing> flowingFluid, Supplier<Block> block, Supplier<? extends Item> bucket) {
            super(sourceFluid, flowingFluid, block, bucket, reactant.getColour(), reactant);
        }

        public int func_207192_d(FluidState state) {
            return 8;
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends ReactantFluid {
        public Flowing(Reactants reactant, Supplier<Source> sourceFluid, Supplier<Flowing> flowingFluid, Supplier<Block> block, Supplier<? extends Item> bucket) {
            super(sourceFluid, flowingFluid, block, bucket, reactant.getColour(), reactant);
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState state) {
            return (Integer)state.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }
}

