/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.model;

import com.google.common.collect.Lists;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.zerocore.lib.client.model.multiblock.CuboidPartVariantsModelBuilder;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractMultiblockModelBuilder<PartType extends Enum<PartType>>
extends CuboidPartVariantsModelBuilder {
    public AbstractMultiblockModelBuilder(ResourceLocation template, boolean ambientOcclusion) {
        super(template, ambientOcclusion);
    }

    protected abstract String getMultiblockShortName();

    protected void addBlockWithVariants(PartType partType, IMultiblockVariant variant, Predicate<PartType> isPartCompatibleWithVariant, String blockCommonName, String ... additionalVariantsModelNames) {
        this.addBlock(partType, variant, isPartCompatibleWithVariant, blockCommonName);
        this.addBlockVariants(partType, variant, isPartCompatibleWithVariant, blockCommonName, additionalVariantsModelNames);
    }

    protected void addBlock(PartType partType, IMultiblockVariant variant, Predicate<PartType> isPartCompatibleWithVariant, String blockCommonName) {
        if (isPartCompatibleWithVariant.test(partType)) {
            super.addBlock(((Enum)partType).ordinal(), this.getBlockStateRL(variant, blockCommonName), 0, false);
        }
    }

    protected void addBlockVariants(PartType partType, IMultiblockVariant variant, Predicate<PartType> isPartCompatibleWithVariant, String blockCommonName, String ... additionalVariantsModelNames) {
        if (isPartCompatibleWithVariant.test(partType)) {
            ArrayList variants = Lists.newArrayListWithCapacity((int)(1 + additionalVariantsModelNames.length));
            variants.add(this.getBlockStateRL(variant, blockCommonName));
            Arrays.stream(additionalVariantsModelNames).map(name -> this.getModelRL(variant, (String)name)).collect(Collectors.toCollection(() -> variants));
            this.addModels(((Enum)partType).ordinal(), variants);
        }
    }

    protected ResourceLocation getBlockStateRL(IMultiblockVariant variant, String blockCommonName) {
        return this.getBlockStateRL(variant, blockCommonName, "");
    }

    protected ResourceLocation getBlockStateRL(IMultiblockVariant variant, String blockCommonName, String blockStateVariant) {
        return new ModelResourceLocation(ExtremeReactors.newID(variant.getName() + "_" + this.getMultiblockShortName() + blockCommonName), blockStateVariant);
    }

    protected ResourceLocation getModelRL(IMultiblockVariant variant, String modelName) {
        return ExtremeReactors.newID("block/" + this.getMultiblockShortName() + "/" + variant.getName() + "/" + modelName);
    }
}

