/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.IMachineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.InputSensorAction;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.NonNullPredicate;

public abstract class AbstractSensorSetting<Reader extends IMachineReader, Writer, SensorType extends ISensorType<Reader>>
implements NonNullPredicate<Reader>,
InputSensorAction<Writer> {
    public final SensorType Sensor;
    public final SensorBehavior Behavior;
    public final int Value1;
    public final int Value2;

    protected AbstractSensorSetting(SensorType sensor, SensorBehavior behavior, int v1, int v2) {
        this.Sensor = sensor;
        this.Behavior = behavior;
        this.Value1 = v1;
        this.Value2 = v2;
    }

    protected AbstractSensorSetting(CompoundNBT data, Function<CompoundNBT, SensorType> sensorTypeGetter) throws IllegalArgumentException {
        if (!(data.func_74764_b("behavior") && data.func_74764_b("v1") && data.func_74764_b("v2"))) {
            throw new IllegalArgumentException("Invalid NBT data");
        }
        this.Sensor = (ISensorType)sensorTypeGetter.apply(data);
        this.Behavior = (SensorBehavior)NBTHelper.nbtGetEnum((CompoundNBT)data, (String)"behavior", SensorBehavior::valueOf, (Enum)SensorBehavior.Disabled);
        this.Value1 = data.func_74762_e("v1");
        this.Value2 = data.func_74762_e("v2");
    }

    public CompoundNBT syncDataTo(CompoundNBT data) {
        NBTHelper.nbtSetEnum((CompoundNBT)data, (String)"behavior", (Enum)this.Behavior);
        data.func_74768_a("v1", this.Value1);
        data.func_74768_a("v2", this.Value2);
        return data;
    }

    public boolean test(Reader reader) {
        return this.Sensor.isOutput() && this.Behavior.outputTest((Integer)this.Sensor.apply(reader), this.Value1, this.Value2);
    }
}

