/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerFluidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerSolidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.BooleanData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.DoubleData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.EnumData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.ItemStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.WideAmountData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidizerControllerContainer
extends ModTileContainer<FluidizerControllerEntity> {
    private final ItemStack[] _solidInputs;
    private final FluidStack[] _fluidInputs;
    private final List<FluidizerSolidInjectorEntity> _solidInjectors;
    private final List<FluidizerFluidInjectorEntity> _fluidInjectors;
    private final int _outputCapacity;
    private boolean _active;
    private IFluidizerRecipe.Type _recipeType;
    private FluidStack _output;
    private WideAmount _energyStored;
    private double _recipeProgress;

    public FluidizerControllerContainer(int windowId, PlayerInventory playerInventory, FluidizerControllerEntity controller) {
        super(ContainerFactory.EMPTY, (ContainerType)Content.ContainerTypes.FLUIDIZER_CONTROLLER.get(), windowId, (AbstractModBlockEntity)controller);
        MultiblockFluidizer fluidizer = (MultiblockFluidizer)controller.getMultiblockController().orElseThrow(IllegalStateException::new);
        this._active = false;
        this._recipeType = IFluidizerRecipe.Type.Invalid;
        this._output = FluidStack.EMPTY;
        this._energyStored = WideAmount.ZERO;
        this._recipeProgress = 0.0;
        this._outputCapacity = fluidizer.getFluidHandler().getTankCapacity(0);
        this._solidInputs = new ItemStack[2];
        Arrays.fill(this._solidInputs, ItemStack.field_190927_a);
        this._fluidInputs = new FluidStack[2];
        Arrays.fill(this._fluidInputs, FluidStack.EMPTY);
        this._solidInjectors = fluidizer.getSolidInjectors();
        this._fluidInjectors = fluidizer.getFluidInjectors();
        if (CodeHelper.calledByLogicalServer((World)fluidizer.getWorld())) {
            int index;
            this.addContainerData((IContainerData)new BooleanData(fluidizer::isMachineActive, v -> {
                this._active = v;
            }));
            this.addContainerData((IContainerData)new EnumData(IFluidizerRecipe.Type.class, fluidizer::getRecipeType, v -> {
                this._recipeType = v;
            }));
            this.addContainerData((IContainerData)new FluidStackData(() -> fluidizer.getFluidHandler().getFluidInTank(0), v -> {
                this._output = v;
            }));
            this.addContainerData((IContainerData)new WideAmountData(() -> fluidizer.getEnergyStorage().getEnergyStored(EnergySystem.ForgeEnergy), v -> {
                this._energyStored = v.copy();
            }));
            this.addContainerData((IContainerData)new DoubleData(fluidizer::getRecipeProgress, v -> {
                this._recipeProgress = v;
            }));
            int i = 0;
            while (i < Math.min(2, this._solidInjectors.size())) {
                index = i++;
                this.addContainerData((IContainerData)new ItemStackData(() -> this._solidInjectors.get(index).getStack(), v -> {
                    this._solidInputs[index] = v;
                }));
            }
            i = 0;
            while (i < Math.min(2, this._fluidInjectors.size())) {
                index = i++;
                this.addContainerData((IContainerData)new FluidStackData(() -> this._fluidInjectors.get(index).getStack(), v -> {
                    this._fluidInputs[index] = v;
                }));
            }
        } else {
            int index;
            this.addContainerData((IContainerData)new BooleanData(this::isFluidizerActive, v -> {
                this._active = v;
            }));
            this.addContainerData((IContainerData)new EnumData(IFluidizerRecipe.Type.class, this::getRecipeType, v -> {
                this._recipeType = v;
            }));
            this.addContainerData((IContainerData)new FluidStackData(this::getOutput, v -> {
                this._output = v;
            }));
            this.addContainerData((IContainerData)new WideAmountData(this::getEnergyStored, v -> {
                this._energyStored = v.copy();
            }));
            this.addContainerData((IContainerData)new DoubleData(this::getRecipeProgress, v -> {
                this._recipeProgress = v;
            }));
            int i = 0;
            while (i < Math.min(2, this._solidInjectors.size())) {
                index = i++;
                this.addContainerData((IContainerData)new ItemStackData(() -> this.getSolidInput(index), v -> {
                    this._solidInputs[index] = v;
                }));
            }
            i = 0;
            while (i < Math.min(2, this._fluidInjectors.size())) {
                index = i++;
                this.addContainerData((IContainerData)new FluidStackData(() -> this.getFluidInput(index), v -> {
                    this._fluidInputs[index] = v;
                }));
            }
        }
    }

    public FluidizerControllerContainer(int windowId, PlayerInventory playerInventory, PacketBuffer networkData) {
        this(windowId, playerInventory, (FluidizerControllerEntity)AbstractModBlockEntity.getGuiClientBlockEntity((PacketBuffer)networkData));
    }

    public IFluidizerRecipe.Type getRecipeType() {
        return this._recipeType;
    }

    public ItemStack getSolidInput(int index) {
        return this._solidInputs[index];
    }

    public FluidStack getFluidInput(int index) {
        return this._fluidInputs[index];
    }

    public int getFluidInputAmount(int index) {
        return this._fluidInputs[index].getAmount();
    }

    public FluidStack getOutput() {
        return this._output;
    }

    public int getOutputAmount() {
        return this._output.getAmount();
    }

    public int getOutputCapacity() {
        return this._outputCapacity;
    }

    public WideAmount getEnergyStored() {
        return this._energyStored;
    }

    public double getRecipeProgress() {
        return this._recipeProgress;
    }

    public boolean isFluidizerActive() {
        return this._active;
    }
}

