/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen;

import com.google.common.collect.ImmutableList;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorControllerEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MonoConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MultiConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.client.text.BindableTextComponent;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public class ReprocessorControllerScreen
extends AbstractMultiblockScreen<MultiblockReprocessor, ReprocessorControllerEntity, ModTileContainer<ReprocessorControllerEntity>> {
    private static final ITextComponent TEXT_EMPTY = new TranslationTextComponent("gui.bigreactors.generic.empty").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private static final int VBARPANEL_WIDTH = 18;
    private static final int VBARPANEL_HEIGHT = 84;
    private final MultiblockReprocessor _reprocessor = (MultiblockReprocessor)((Object)this.getMultiblockController().orElseThrow(IllegalStateException::new));
    private final BindingGroup _bindings = new BindingGroup();
    private final GaugeBar _energyBar = new GaugeBar((ModContainerScreen)this, "energyBar", 5000.0, CommonIcons.PowerBar.get());
    private final GaugeBar _fluidBar = new GaugeBar((ModContainerScreen)this, "fluidbar", 5000.0, CommonIcons.BarBackground.get());
    private final GaugeBar _progressBar = new GaugeBar((ModContainerScreen)this, "progress", 1.0, Sprite.EMPTY);
    private final Static _inputInventoryDisplay = new Static((ModContainerScreen)this, 16, 16);
    private final Static _outputInventoryDisplay = new Static((ModContainerScreen)this, 16, 16);

    public ReprocessorControllerScreen(ModTileContainer<ReprocessorControllerEntity> container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, PlayerInventoryUsage.None, title, (NonNullSupplier<SpriteTextureMap>)((NonNullSupplier)() -> new SpriteTextureMap(ExtremeReactors.newID("textures/gui/multiblock/basic_background.png"), 256, 256)));
    }

    public boolean func_231178_ax__() {
        return true;
    }

    @Override
    protected void onScreenCreate() {
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, ExtremeReactors.newID("reprocessor/part-controller"), 1);
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setVerticalMargin(1)).setHorizontalMargin(13)).setControlsSpacing(0));
        Panel mainPanel = new Panel((ModContainerScreen)this);
        mainPanel.setDesiredDimension(DesiredDimension.Height, 84);
        mainPanel.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        this.addControl((IControl)mainPanel);
        Panel p = this.vBarPanel();
        this.addBarIcon(CommonIcons.PowerBattery, 16, 16, p).useTooltipsFrom((IControl)this._energyBar);
        BindableTextComponent energyStoredText = new BindableTextComponent(stored -> new StringTextComponent(CodeHelper.formatAsHumanReadableNumber((double)stored, (String)EnergySystem.ForgeEnergy.getUnit())).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent energyStoredPercentageText = new BindableTextComponent(percentage -> new StringTextComponent(String.format("%d", (int)(percentage * 100.0))).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE));
        this._energyBar.setDesiredDimension(18, 66);
        this._energyBar.setBackground(CommonIcons.BarBackground.get());
        this._energyBar.setPadding(1);
        this._energyBar.setTooltips((List)ImmutableList.of((Object)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.energybar.line1").func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.energybar.line2a").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.energybar.line2b", new Object[]{CodeHelper.formatAsHumanReadableNumber((long)5000L, (String)EnergySystem.ForgeEnergy.getUnit())})), (Object)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.energybar.line3a").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.energybar.line3b"))), (List)ImmutableList.of((Object)energyStoredText, (Object)energyStoredPercentageText));
        Consumer[] consumerArray = new Consumer[2];
        consumerArray[0] = arg_0 -> ((GaugeBar)this._energyBar).setValue(arg_0);
        consumerArray[1] = energyStoredText;
        this.addBinding(MultiblockReprocessor::getEnergyStored, consumerArray);
        this.addBinding((Function<MultiblockReprocessor, Value>)((Function<MultiblockReprocessor, Double>)MultiblockReprocessor::getEnergyStoredPercentage), (Consumer<Value>)((Consumer)energyStoredPercentageText));
        p.addControl((IControl)this._energyBar);
        mainPanel.addControl((IControl)p);
        mainPanel.addControl((IControl)this.vSeparatorPanel());
        BindableTextComponent fluidName = new BindableTextComponent(name -> name);
        BindableTextComponent fluidAmount = new BindableTextComponent(amount -> new StringTextComponent(CodeHelper.formatAsMillibuckets((float)amount.intValue())).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent fluidStoredPercentage = new BindableTextComponent(percentage -> new StringTextComponent(String.format("%d", (int)(percentage * 100.0))).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.vBarPanel();
        this.addBarIcon((NonNullSupplier<ISprite>)CodeHelper.asNonNull(CachedSprites.VANILLA_BUCKET, () -> Sprite.EMPTY), p).useTooltipsFrom((IControl)this._fluidBar);
        this._fluidBar.setMaxValue(5000.0);
        this._fluidBar.setDesiredDimension(18, 66);
        this._fluidBar.setBackground(CommonIcons.BarBackground.get());
        this._fluidBar.setPadding(1);
        this._fluidBar.setTooltips((List)ImmutableList.of((Object)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.coolantbar.line1").func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.coreheatbar.line2").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.coolantbar.line3a").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.coolantbar.line3b", new Object[]{CodeHelper.formatAsMillibuckets((float)5000.0f)})), (Object)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.coolantbar.line4a").func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.bigreactors.reprocessor.controller.coolantbar.line4b"))), (List)ImmutableList.of((Object)fluidName, (Object)fluidAmount, (Object)fluidStoredPercentage));
        this.addBinding((MultiblockReprocessor r) -> ReprocessorControllerScreen.getFluidName(r.getFluidHandler().getFluidInTank(0)), new Consumer[]{v -> {
            this._fluidBar.setBarSprite(Sprite.EMPTY);
            this._fluidBar.setBarSpriteTint(Colour.WHITE);
            FluidStack fluidStack = this._reprocessor.getFluidHandler().getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                Fluid fluid = fluidStack.getFluid();
                ISprite fluidSprite = ModRenderHelper.getFlowingFluidSprite((Fluid)fluid.getFluid());
                Colour fluidTint = Colour.fromARGB((int)fluid.getAttributes().getColor());
                this._fluidBar.setBarSprite(fluidSprite);
                this._fluidBar.setBarSpriteTint(fluidTint);
                this._progressBar.setBarSprite(fluidSprite);
                this._progressBar.setBarSpriteTint(fluidTint);
            }
        }, fluidName});
        Consumer[] consumerArray2 = new Consumer[2];
        consumerArray2[0] = arg_0 -> ((GaugeBar)this._fluidBar).setValue(arg_0);
        consumerArray2[1] = fluidAmount;
        this.addBinding(MultiblockReprocessor::getFluidStored, consumerArray2);
        this.addBinding(MultiblockReprocessor::getFluidStoredPercentage, new Consumer[]{v -> {}, fluidStoredPercentage});
        p.addControl((IControl)this._fluidBar);
        mainPanel.addControl((IControl)p);
        mainPanel.addControl((IControl)this.vSeparatorPanel());
        mainPanel.addControl((IControl)this.recipePanel());
        mainPanel.addControl((IControl)this.vSeparatorPanel());
        Panel commandPanel = this.vCommandPanel();
        mainPanel.addControl((IControl)commandPanel);
        int x = 0;
        int y = 0;
        int w = 25;
        SwitchButton on = new SwitchButton((ModContainerScreen)this, "on", "ON", false, "onoff");
        SwitchButton off = new SwitchButton((ModContainerScreen)this, "off", "OFF", true, "onoff");
        on.setLayoutEngineHint(FixedLayoutEngine.hint((int)x, (int)y, (int)w, (int)16));
        on.setTooltips(new ITextComponent[]{new TranslationTextComponent("gui.bigreactors.reprocessor.controller.on.line1")});
        on.Activated.subscribe(this::onActiveStateChanged);
        on.Deactivated.subscribe(this::onActiveStateChanged);
        this.addBinding((Function<MultiblockReprocessor, Value>)((Function<MultiblockReprocessor, Boolean>)MultiblockReprocessor::isMachineActive), (Consumer<Value>)((Consumer<Boolean>)arg_0 -> ((SwitchButton)on).setActive(arg_0)));
        off.setLayoutEngineHint(FixedLayoutEngine.hint((int)(x + w), (int)y, (int)w, (int)16));
        off.setTooltips(new ITextComponent[]{new TranslationTextComponent("gui.bigreactors.reprocessor.controller.off.line1")});
        this.addBinding((Function<MultiblockReprocessor, Value>)((Function<MultiblockReprocessor, Boolean>)MultiblockReprocessor::isMachineActive), (Consumer<Value>)((Consumer<Boolean>)active -> off.setActive(active == false)));
        commandPanel.addControl(new IControl[]{on, off});
    }

    @Override
    protected void onDataUpdated() {
        super.onDataUpdated();
        this._bindings.update();
    }

    private final <Value> void addBinding(Function<MultiblockReprocessor, Value> supplier, Consumer<Value> consumer) {
        this._bindings.addBinding((IBinding)new MonoConsumerBinding((Object)this._reprocessor, supplier, consumer));
    }

    @SafeVarargs
    private final <Value> void addBinding(Function<MultiblockReprocessor, Value> supplier, Consumer<Value> ... consumers) {
        this._bindings.addBinding((IBinding)new MultiConsumerBinding((Object)this._reprocessor, supplier, (Consumer[])consumers));
    }

    private void onActiveStateChanged(SwitchButton button) {
        if (!this.isDataUpdateInProgress()) {
            this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
        }
    }

    private static ITextComponent getFluidName(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return TEXT_EMPTY;
        }
        return new TranslationTextComponent(fluidStack.getFluid().getAttributes().getTranslationKey()).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE);
    }

    private Panel vBarPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(18, 84);
        p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2));
        return p;
    }

    private Panel vSeparatorPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        Static s = new Static((ModContainerScreen)this, 1, 84);
        p.setDesiredDimension(11, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        s.setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)5, (int)0, (int)1, (int)84));
        p.addControl((IControl)s);
        return p;
    }

    private Panel vCommandPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(DesiredDimension.Height, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        return p;
    }

    private Panel recipePanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setLayoutEngine((ILayoutEngine)new VerticalLayoutEngine());
        p.setDesiredDimension(DesiredDimension.Width, 64);
        p.addControl((IControl)this._inputInventoryDisplay);
        this.addBinding((Function<MultiblockReprocessor, Value>)((Function<MultiblockReprocessor, ItemStack>)r -> r.getItemHandler(IoDirection.Input).getStackInSlot(0)), (Consumer<Value>)((Consumer<ItemStack>)stack -> ReprocessorControllerScreen.setInventoryDisplay(this._inputInventoryDisplay, stack)));
        this._progressBar.setDesiredDimension(16, 32);
        this._progressBar.setOverlay(new SpriteTextureMap(ExtremeReactors.newID("textures/gui/multiblock/reprocessor_controller_arrow.png"), 16, 32).sprite().ofSize(16, 32).build());
        this._progressBar.setTopDown(true);
        p.addControl((IControl)this._progressBar);
        this.addBinding((Function<MultiblockReprocessor, Value>)((Function<MultiblockReprocessor, Double>)MultiblockReprocessor::getRecipeProgress), (Consumer<Value>)((Consumer<Double>)arg_0 -> ((GaugeBar)this._progressBar).setValue(arg_0)));
        p.addControl((IControl)this._outputInventoryDisplay);
        this.addBinding((Function<MultiblockReprocessor, Value>)((Function<MultiblockReprocessor, ItemStack>)r -> r.getItemHandler(IoDirection.Output).getStackInSlot(0)), (Consumer<Value>)((Consumer<ItemStack>)stack -> ReprocessorControllerScreen.setInventoryDisplay(this._outputInventoryDisplay, stack)));
        return p;
    }

    private static void setInventoryDisplay(Static display, ItemStack stack) {
        if (stack.func_190916_E() > 1) {
            display.setStackWithCount(stack);
        } else {
            display.setStack(stack);
        }
        if (!stack.func_190926_b()) {
            display.setTooltips(new ITextComponent[]{new StringTextComponent(String.format("%dx ", stack.func_190916_E())).func_230529_a_((ITextComponent)new TranslationTextComponent(stack.func_77973_b().func_77658_a()).func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true))))});
        }
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, Panel parent) {
        return this.addBarIcon(icon, 16, 16, parent);
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, int width, int height, Panel parent) {
        Picture c = new Picture((ModContainerScreen)this, this.nextGenericName(), (ISprite)icon.get(), width, height);
        c.setDesiredDimension(width, height);
        parent.addControl((IControl)c);
        return c;
    }
}

